/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Commands;

import com.deadshotmdf.MagicalCrafting.ConfigSettings;
import com.deadshotmdf.MagicalCrafting.MC;
import com.deadshotmdf.MagicalCrafting.Managers.StructureSettingsManager;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.StructureSettings;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AddRemoveFriendCommand
implements CommandExecutor {
    private final MC main;
    private final StructureSettingsManager settingsManager;

    public AddRemoveFriendCommand(MC main, StructureSettingsManager settingsManager) {
        this.main = main;
        this.settingsManager = settingsManager;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only a player may execute this command.");
            return true;
        }
        if (!sender.hasPermission("magicalcrafting.addremovefriends")) {
            sender.sendMessage(ConfigSettings.getNoPermission());
            return true;
        }
        StructureSettings structureSettings = (StructureSettings)this.settingsManager.getValueByIdOrNew(((Player)sender).getUniqueId().toString());
        if (args.length > 0 && args[0].equalsIgnoreCase("list")) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> this.getNamesAsync(sender, structureSettings.getFriendsClone()));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(ConfigSettings.getFriendsCmdUsage());
            return true;
        }
        boolean add = args[0].equalsIgnoreCase("add");
        if (!add && !args[0].equalsIgnoreCase("remove")) {
            sender.sendMessage(ConfigSettings.getFriendsCmdUsage());
            return true;
        }
        UUID uuid = this.settingsManager.getOfflinePlayer(args[1]);
        if (uuid == null) {
            sender.sendMessage(ConfigSettings.getPlayerInvalid(args[1]));
            return true;
        }
        if (((Player)sender).getUniqueId().equals(uuid)) {
            sender.sendMessage(ConfigSettings.getCannotAddFriendSelf());
            return true;
        }
        boolean b = structureSettings.modifyFriend(uuid, add);
        if (add) {
            sender.sendMessage(b ? ConfigSettings.getAddedFriend(args[1]) : ConfigSettings.getAlreadyFriend(args[1]));
        } else {
            sender.sendMessage(b ? ConfigSettings.getRemoveFriend(args[1]) : ConfigSettings.getNotFriend(args[1]));
        }
        return true;
    }

    private void getNamesAsync(CommandSender sender, Set<UUID> uuids) {
        LinkedList<String> names = new LinkedList<String>();
        for (UUID uuid : uuids) {
            try {
                names.add(Objects.requireNonNull(Bukkit.getOfflinePlayer((UUID)uuid).getName()));
            }
            catch (Throwable throwable) {}
        }
        Bukkit.getScheduler().runTask((Plugin)this.main, () -> this.getNamesSync(sender, names));
    }

    private void getNamesSync(CommandSender sender, List<String> names) {
        if (sender == null || !((Player)sender).isOnline()) {
            return;
        }
        StringJoiner joiner = new StringJoiner(", ");
        names.forEach(joiner::add);
        String s = joiner.toString();
        sender.sendMessage(s.isEmpty() ? "EMPTY" : s);
    }
}

