/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Commands;

import com.deadshotmdf.MagicalCrafting.ConfigSettings;
import com.deadshotmdf.MagicalCrafting.MC;
import com.deadshotmdf.MagicalCrafting.Managers.GUIManager;
import com.deadshotmdf.MagicalCrafting.Managers.RecipesManager;
import com.deadshotmdf.MagicalCrafting.Managers.StructureSettingsManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public class ReloadConfigCommand
implements CommandExecutor {
    private final MC main;
    private final StructureSettingsManager settingsManager;
    private final GUIManager guiManager;
    private final RecipesManager recipesManager;

    public ReloadConfigCommand(MC main, StructureSettingsManager settingsManager, GUIManager guiManager, RecipesManager recipesManager) {
        this.main = main;
        this.settingsManager = settingsManager;
        this.guiManager = guiManager;
        this.recipesManager = recipesManager;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender instanceof Player && !sender.hasPermission("magicalcrafting.reload")) {
            sender.sendMessage(ConfigSettings.getNoPermission());
            return true;
        }
        Bukkit.getOnlinePlayers().forEach(HumanEntity::closeInventory);
        ConfigSettings.reloadConfig(this.main);
        this.settingsManager.reloadConfig();
        this.guiManager.reloadConfig(this.main.getConfig());
        this.recipesManager.reloadConfig(this.main.getConfig());
        sender.sendMessage(ConfigSettings.getReloadConfig());
        return true;
    }
}

