/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Commands.Structure_And_Recipe;

import com.deadshotmdf.MagicalCrafting.ConfigSettings;
import com.deadshotmdf.MagicalCrafting.MC;
import com.deadshotmdf.MagicalCrafting.Managers.RecipesManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CreateRemoveRecipeCommand
implements CommandExecutor {
    private final MC main;
    private final RecipesManager recipesManager;

    public CreateRemoveRecipeCommand(MC main, RecipesManager recipesManager) {
        this.main = main;
        this.recipesManager = recipesManager;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        boolean exists;
        if (sender instanceof Player && !sender.hasPermission("magicalcrafting.createremove")) {
            sender.sendMessage(ConfigSettings.getNoPermission());
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(ConfigSettings.getCreateRemoveCmdUsage());
            return true;
        }
        boolean add = args[0].equalsIgnoreCase("add");
        if (!add && !args[0].equalsIgnoreCase("remove")) {
            sender.sendMessage(ConfigSettings.getCreateRemoveCmdUsage());
            return true;
        }
        boolean bl = exists = this.recipesManager.getValueById(args[1]) != null;
        if (add) {
            if (exists) {
                sender.sendMessage(ConfigSettings.getRecipeAlreadyExists(args[1]));
                return true;
            }
            this.recipesManager.createRecipe(this.main, args[1]);
        } else {
            if (!exists) {
                sender.sendMessage(ConfigSettings.getRecipeDoesNotExist(args[1]));
                return true;
            }
            this.recipesManager.removeRecipe(args[1]);
        }
        sender.sendMessage(add ? ConfigSettings.getRecipeCreated(args[1]) : ConfigSettings.getRecipeRemoved(args[1]));
        return true;
    }
}

