/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Commands.Structure_And_Recipe;

import com.deadshotmdf.MagicalCrafting.ConfigSettings;
import com.deadshotmdf.MagicalCrafting.Managers.GUIManager;
import com.deadshotmdf.MagicalCrafting.Managers.RecipesManager;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.MagicalRecipe;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EditRecipeCommand
implements CommandExecutor {
    private final RecipesManager recipesManager;
    private final GUIManager guiManager;

    public EditRecipeCommand(RecipesManager recipesManager, GUIManager guiManager) {
        this.recipesManager = recipesManager;
        this.guiManager = guiManager;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only a player may execute this command.");
            return true;
        }
        if (!sender.hasPermission("magicalcrafting.editrecipe")) {
            sender.sendMessage(ConfigSettings.getNoPermission());
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(ConfigSettings.getEditRecipeCmdUsage());
            return true;
        }
        MagicalRecipe recipe = (MagicalRecipe)this.recipesManager.getValueById(args[0]);
        if (recipe == null) {
            sender.sendMessage(ConfigSettings.getRecipeDoesNotExist(args[0]));
            return true;
        }
        this.guiManager.openEditRecipeInventory((Player)sender, args[0].toLowerCase(), recipe);
        return true;
    }
}

