/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Commands.Structure_And_Recipe;

import com.deadshotmdf.MagicalCrafting.ConfigSettings;
import com.deadshotmdf.MagicalCrafting.Managers.StructureManager;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.CraftStructure;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.MagicalRecipe;
import java.util.StringJoiner;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SeeRecipesForStructureCommand
implements CommandExecutor {
    private final StructureManager structureManager;

    public SeeRecipesForStructureCommand(StructureManager structureManager) {
        this.structureManager = structureManager;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender instanceof Player && !sender.hasPermission("magicalcrafting.seerecipes")) {
            sender.sendMessage(ConfigSettings.getNoPermission());
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(ConfigSettings.getSeeRecipesStructureCmdUsage());
            return true;
        }
        CraftStructure craftStructure = (CraftStructure)this.structureManager.getValueById(args[0]);
        if (craftStructure == null) {
            sender.sendMessage(ConfigSettings.getStructureDoesNotExist(args[0]));
            return true;
        }
        StringJoiner stringJoiner = new StringJoiner(", ");
        for (MagicalRecipe magicalRecipe : craftStructure.getRecipes()) {
            stringJoiner.add(magicalRecipe.getId());
        }
        if (stringJoiner.length() == 0) {
            sender.sendMessage("EMPTY");
        } else {
            sender.sendMessage(stringJoiner.toString());
        }
        return true;
    }
}

