/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Commands.Structure_And_Recipe;

import com.deadshotmdf.MagicalCrafting.ConfigSettings;
import com.deadshotmdf.MagicalCrafting.Managers.ActiveStructuresManager;
import com.deadshotmdf.MagicalCrafting.Managers.RecipesManager;
import com.deadshotmdf.MagicalCrafting.Managers.StructureManager;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.ActiveStructure;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.CraftStructure;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.MagicalRecipe;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StructureAddRemoveRecipeCommand
implements CommandExecutor {
    private final RecipesManager recipesManager;
    private final StructureManager structureManager;
    private final ActiveStructuresManager activeStructuresManager;

    public StructureAddRemoveRecipeCommand(RecipesManager recipesManager, StructureManager structureManager, ActiveStructuresManager activeStructuresManager) {
        this.recipesManager = recipesManager;
        this.structureManager = structureManager;
        this.activeStructuresManager = activeStructuresManager;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender instanceof Player && !sender.hasPermission("magicalcrafting.structureaddremoverecipe")) {
            sender.sendMessage(ConfigSettings.getNoPermission());
            return true;
        }
        if (args.length < 3) {
            sender.sendMessage(ConfigSettings.getStructureCreateRemoveCmdUsage());
            return true;
        }
        boolean add = args[0].equalsIgnoreCase("add");
        boolean all = args[1].equals("*");
        boolean allRecipes = args[2].equals("*");
        if (!add && !args[0].equalsIgnoreCase("remove")) {
            sender.sendMessage(ConfigSettings.getStructureCreateRemoveCmdUsage());
            return true;
        }
        CraftStructure craftStructure = (CraftStructure)this.structureManager.getValueById(args[1]);
        if (craftStructure == null && !all) {
            sender.sendMessage(ConfigSettings.getStructureDoesNotExist(args[1]));
            return true;
        }
        MagicalRecipe magicalRecipe = (MagicalRecipe)this.recipesManager.getValueById(args[2]);
        if (magicalRecipe == null && !allRecipes) {
            sender.sendMessage(ConfigSettings.getRecipeDoesNotExist(args[2]));
            return true;
        }
        if (all) {
            this.structureManager.getValues().forEach(structure -> this.modifyRecipeForStructure((CraftStructure)structure, magicalRecipe, allRecipes, add));
        } else {
            this.modifyRecipeForStructure(craftStructure, magicalRecipe, allRecipes, add);
        }
        sender.sendMessage(ConfigSettings.getStructureCreateRemoveCmdUse(add ? "ADDED" : "REMOVED", allRecipes ? "*" : magicalRecipe.getId(), all ? "*" : craftStructure.getId()));
        return true;
    }

    private void modifyRecipeForStructure(CraftStructure structure, MagicalRecipe magicalRecipe, boolean allRecipes, boolean add) {
        if (allRecipes) {
            if (add) {
                structure.getRecipes().addAll(this.recipesManager.getValues());
            } else {
                structure.getRecipes().clear();
            }
        } else if (add) {
            structure.getRecipes().add(magicalRecipe);
        } else {
            structure.getRecipes().remove(magicalRecipe);
        }
        for (ActiveStructure activeStructure : this.activeStructuresManager.getValues()) {
            if (add || !allRecipes && !magicalRecipe.equals(activeStructure.getCurrentRecipe())) continue;
            activeStructure.stopRecipe();
        }
    }
}

