/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting;

import com.deadshotmdf.MagicalCrafting.MC;
import com.deadshotmdf.MagicalCrafting.Metrics;
import com.deadshotmdf.MagicalCrafting.Utils.ConfigUpdater;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigSettings {
    private static String reloadConfig;
    private static String noPermission;
    private static boolean updateNotifications;
    private static boolean onlyOwnerCanInteract;
    private static String invalidLocations;
    private static String noBlock;
    private static String sameId;
    private static String structureCreated;
    private static String structureRemoved;
    private static String noCore;
    private static String pos1Selected;
    private static String pos2Selected;
    private static String invalidCommand;
    private static String invalidId;
    private static boolean requirePermissionToBuild;
    private static String selectedCore;
    private static String unselectedCore;
    private static String selectedPedestal;
    private static String unselectedPedestal;
    private static String recipeDoesNotExist;
    private static String recipeAlreadyExists;
    private static String createRemoveCmdUsage;
    private static String editRecipeCmdUsage;
    private static String recipeCreated;
    private static String recipeRemoved;
    private static String structureCreateRemoveCmdUsage;
    private static String structureDoesNotExist;
    private static String structureCreateRemoveCmdUse;
    private static String seeRecipesStructureCmdUsage;
    private static String awaitInputMainMessage;
    private static String invalidInputMainMessage;
    private static String recipeMainGuiTitle;
    private static String recipeIngredientsGuiTitle;
    private static String altarSettingsInventoryName;
    private static String friendsCmdUsage;
    private static String playerInvalid;
    private static String addedFriend;
    private static String alreadyFriend;
    private static String removeFriend;
    private static String notFriend;
    private static String cannotAddFriendSelf;
    private static Metrics metrics;

    public static String getReloadConfig() {
        return reloadConfig;
    }

    public static String getNoPermission() {
        return noPermission;
    }

    public static boolean getUpdateNotifications() {
        return updateNotifications;
    }

    public static boolean getOnlyOwnerCanInteract() {
        return onlyOwnerCanInteract;
    }

    public static String getInvalidLocations() {
        return invalidLocations;
    }

    public static String getNoBlock() {
        return noBlock;
    }

    public static String getSameId(String id) {
        return sameId.replace("{id}", id);
    }

    public static String getStructureCreated(String id, int blocks, int pedestals) {
        return structureCreated.replace("{id}", id).replace("{blocks}", ConfigSettings.s(blocks)).replace("{pedestals}", ConfigSettings.s(pedestals));
    }

    public static String getStructureRemoved(String id) {
        return structureRemoved.replace("{id}", id);
    }

    public static String getNoCore() {
        return noCore;
    }

    public static String getPos1Selected(Location location) {
        return pos1Selected.replace("{world}", location.getWorld().getName()).replace("{x}", ConfigSettings.s(location.getBlockX())).replace("{y}", ConfigSettings.s(location.getBlockY())).replace("{z}", ConfigSettings.s(location.getBlockZ()));
    }

    public static String getPos2Selected(Location location) {
        return pos2Selected.replace("{world}", location.getWorld().getName()).replace("{x}", ConfigSettings.s(location.getBlockX())).replace("{y}", ConfigSettings.s(location.getBlockY())).replace("{z}", ConfigSettings.s(location.getBlockZ()));
    }

    public static String getInvalidCommand() {
        return invalidCommand;
    }

    public static String getInvalidId(String id) {
        return invalidId.replace("{id}", id);
    }

    public static boolean getRequirePermissionToBuild() {
        return requirePermissionToBuild;
    }

    public static String getSelectedCore() {
        return selectedCore;
    }

    public static String getUnselectedCore() {
        return unselectedCore;
    }

    public static String getSelectedPedestal() {
        return selectedPedestal;
    }

    public static String getUnselectedPedestal() {
        return unselectedPedestal;
    }

    public static String getRecipeDoesNotExist(String id) {
        return recipeDoesNotExist.replace("{id}", id);
    }

    public static String getRecipeAlreadyExists(String id) {
        return recipeAlreadyExists.replace("{id}", id);
    }

    public static String getCreateRemoveCmdUsage() {
        return createRemoveCmdUsage;
    }

    public static String getEditRecipeCmdUsage() {
        return editRecipeCmdUsage;
    }

    public static String getRecipeCreated(String id) {
        return recipeCreated.replace("{id}", id);
    }

    public static String getRecipeRemoved(String id) {
        return recipeRemoved.replace("{id}", id);
    }

    public static String getStructureCreateRemoveCmdUsage() {
        return structureCreateRemoveCmdUsage;
    }

    public static String getStructureDoesNotExist(String structure) {
        return structureDoesNotExist.replace("{structure}", structure);
    }

    public static String getStructureCreateRemoveCmdUse(String action, String recipe, String structure) {
        return structureCreateRemoveCmdUse.replace("{action}", action).replace("{recipe}", recipe).replace("{structure}", structure);
    }

    public static String getSeeRecipesStructureCmdUsage() {
        return seeRecipesStructureCmdUsage;
    }

    public static String getAwaitInputMainMessage() {
        return awaitInputMainMessage;
    }

    public static String getInvalidInputMainMessage(String invalid) {
        return invalidInputMainMessage.replace("{invalid}", invalid);
    }

    public static String getRecipeMainGuiTitle() {
        return recipeMainGuiTitle;
    }

    public static String getRecipeIngredientsGuiTitle() {
        return recipeIngredientsGuiTitle;
    }

    public static String getAltarSettingsInventoryName() {
        return altarSettingsInventoryName;
    }

    public static String getFriendsCmdUsage() {
        return friendsCmdUsage;
    }

    public static String getPlayerInvalid(String player) {
        return playerInvalid.replace("{player}", player);
    }

    public static String getAddedFriend(String player) {
        return addedFriend.replace("{player}", player);
    }

    public static String getAlreadyFriend(String player) {
        return alreadyFriend.replace("{player}", player);
    }

    public static String getRemoveFriend(String player) {
        return removeFriend.replace("{player}", player);
    }

    public static String getNotFriend(String player) {
        return notFriend.replace("{player}", player);
    }

    public static String getCannotAddFriendSelf() {
        return cannotAddFriendSelf;
    }

    public static void reloadConfig(MC main) {
        main.saveDefaultConfig();
        main.reloadConfig();
        FileConfiguration config = main.getConfig();
        if (!config.getString("configVersion", "0.0").equals("1.2")) {
            try {
                Files.copy(new File(main.getDataFolder(), "config.yml").toPath(), new File(main.getDataFolder(), "config-pre1_2_backup.yml").toPath(), StandardCopyOption.REPLACE_EXISTING);
                ConfigUpdater.update((Plugin)main, "config.yml", new File(main.getDataFolder(), "config.yml"), new ArrayList<String>());
                main.reloadConfig();
                ConfigSettings.reloadConfig(main);
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        reloadConfig = ConfigSettings.color(config.getString("reloadConfig"));
        noPermission = ConfigSettings.color(config.getString("noPermission"));
        if (metrics != null) {
            metrics.shutdown();
            metrics = null;
        }
        if (config.getBoolean("useBStats")) {
            metrics = new Metrics((Plugin)main, 23164);
        }
        updateNotifications = config.getBoolean("updateNotifications");
        onlyOwnerCanInteract = config.getBoolean("onlyOwnerCanInteract");
        invalidLocations = ConfigSettings.color(config.getString("invalidLocations"));
        noBlock = ConfigSettings.color(config.getString("noBlock"));
        sameId = ConfigSettings.color(config.getString("sameId"));
        structureCreated = ConfigSettings.color(config.getString("structureCreated"));
        structureRemoved = ConfigSettings.color(config.getString("structureRemoved"));
        noCore = ConfigSettings.color(config.getString("noCore"));
        pos1Selected = ConfigSettings.color(config.getString("pos1Selected"));
        pos2Selected = ConfigSettings.color(config.getString("pos2Selected"));
        invalidCommand = ConfigSettings.color(config.getString("invalidCommand"));
        invalidId = ConfigSettings.color(config.getString("invalidId"));
        requirePermissionToBuild = config.getBoolean("requirePermissionToBuild");
        selectedCore = ConfigSettings.color(config.getString("selectedCore"));
        unselectedCore = ConfigSettings.color(config.getString("unselectedCore"));
        selectedPedestal = ConfigSettings.color(config.getString("selectedPedestal"));
        unselectedPedestal = ConfigSettings.color(config.getString("unselectedPedestal"));
        recipeDoesNotExist = ConfigSettings.color(config.getString("recipeDoesNotExist"));
        recipeAlreadyExists = ConfigSettings.color(config.getString("recipeAlreadyExists"));
        createRemoveCmdUsage = ConfigSettings.color(config.getString("createRemoveCmdUsage"));
        editRecipeCmdUsage = ConfigSettings.color(config.getString("editRecipeCmdUsage"));
        recipeCreated = ConfigSettings.color(config.getString("recipeCreated"));
        recipeRemoved = ConfigSettings.color(config.getString("recipeRemoved"));
        structureCreateRemoveCmdUsage = ConfigSettings.color(config.getString("structureCreateRemoveCmdUsage"));
        structureDoesNotExist = ConfigSettings.color(config.getString("structureDoesNotExist"));
        structureCreateRemoveCmdUse = ConfigSettings.color(config.getString("structureCreateRemoveCmdUse"));
        seeRecipesStructureCmdUsage = ConfigSettings.color(config.getString("seeRecipesStructureCmdUsage"));
        awaitInputMainMessage = ConfigSettings.color(config.getString("awaitInputMainMessage"));
        invalidInputMainMessage = ConfigSettings.color(config.getString("invalidInputMainMessage"));
        recipeMainGuiTitle = ConfigSettings.color(config.getString("recipeMainGuiTitle"));
        recipeIngredientsGuiTitle = ConfigSettings.color(config.getString("recipeIngredientsGuiTitle"));
        altarSettingsInventoryName = ConfigSettings.color(config.getString("altarSettingsInventoryName"));
        friendsCmdUsage = ConfigSettings.color(config.getString("friendsCmdUsage"));
        playerInvalid = ConfigSettings.color(config.getString("playerInvalid"));
        addedFriend = ConfigSettings.color(config.getString("addedFriend"));
        alreadyFriend = ConfigSettings.color(config.getString("alreadyFriend"));
        removeFriend = ConfigSettings.color(config.getString("removeFriend"));
        notFriend = ConfigSettings.color(config.getString("notFriend"));
        cannotAddFriendSelf = ConfigSettings.color(config.getString("cannotAddFriendSelf"));
    }

    public static String color(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)(s != null ? s : "NULL"));
    }

    public static List<String> color(List<String> list) {
        return list == null || list.isEmpty() ? new ArrayList<String>() : list.stream().map(ConfigSettings::color).collect(Collectors.toList());
    }

    public static List<String> replace(List<String> list, String[] toReplace, String[] replace) {
        if (toReplace == null || replace == null) {
            return list;
        }
        LinkedList<String> lore = new LinkedList<String>();
        for (String s : list) {
            lore.add(StringUtils.replaceEach((String)s, (String[])toReplace, (String[])replace));
        }
        return lore;
    }

    public static String getWaitTime(int s) {
        long days = TimeUnit.SECONDS.toDays(s);
        long hours = TimeUnit.SECONDS.toHours(s) % 24L;
        long minutes = TimeUnit.SECONDS.toMinutes(s) % 60L;
        long seconds = s % 60;
        return String.format("%d:%02d:%02d:%02d", days, hours, minutes, seconds);
    }

    public static Integer convertToSeconds(String message) {
        int timeValue;
        if (message == null || message.isEmpty()) {
            return null;
        }
        message = message.trim();
        int length = message.length();
        int timeUnit = message.charAt(length - 1);
        String numberPart = message.substring(0, length - 1);
        try {
            if (Character.isDigit((char)timeUnit)) {
                timeValue = Integer.parseInt(message);
                timeUnit = 115;
            } else {
                timeValue = Integer.parseInt(numberPart);
            }
            if (timeValue < 0) {
                return null;
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        switch (timeUnit) {
            case 115: {
                return timeValue;
            }
            case 109: {
                return timeValue * 60;
            }
            case 104: {
                return timeValue * 3600;
            }
            case 100: {
                return timeValue * 86400;
            }
        }
        return null;
    }

    private static String s(Object o) {
        return String.valueOf(o);
    }
}

