/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Listeners;

import com.deadshotmdf.MagicalCrafting.ConfigSettings;
import com.deadshotmdf.MagicalCrafting.Managers.ActiveStructuresManager;
import com.deadshotmdf.MagicalCrafting.Managers.FancyManager;
import com.deadshotmdf.MagicalCrafting.Managers.StructureManager;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;

public class CompleteStructureLis
implements Listener {
    private final StructureManager structureManager;
    private final ActiveStructuresManager activeStructuresManager;
    private final FancyManager fancyManager;

    public CompleteStructureLis(StructureManager structureManager, ActiveStructuresManager activeStructuresManager, FancyManager fancyManager) {
        this.structureManager = structureManager;
        this.activeStructuresManager = activeStructuresManager;
        this.fancyManager = fancyManager;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent ev) {
        if (ev.isCancelled()) {
            return;
        }
        Player player = ev.getPlayer();
        if (ConfigSettings.getRequirePermissionToBuild() && !player.hasPermission("magicalcrafting.buildstructure")) {
            return;
        }
        Location placedLocation = ev.getBlockPlaced().getLocation();
        Material material = ev.getItemInHand().getType();
        if (!this.structureManager.isValid(material)) {
            return;
        }
        Object[] data = this.activeStructuresManager.checkForStructureCompletion(placedLocation, material);
        if (data == null || data.length != 2) {
            return;
        }
        HashMap completedStructure = (HashMap)data[0];
        if (completedStructure == null || completedStructure.isEmpty() || data[1] == null) {
            return;
        }
        this.activeStructuresManager.addActiveStructure(ev.getPlayer(), completedStructure, (String)data[1]);
        this.fancyManager.completeStructure(completedStructure);
    }
}

