/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Listeners;

import com.deadshotmdf.MagicalCrafting.Managers.ActiveStructuresManager;
import com.deadshotmdf.MagicalCrafting.Managers.RecipesManager;
import com.deadshotmdf.MagicalCrafting.Managers.StructureSettingsManager;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.ActiveStructure;
import com.deadshotmdf.MagicalCrafting.Utils.MCUtils;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class InteractStructureLis
implements Listener {
    private final ActiveStructuresManager activeStructuresManager;
    private final RecipesManager recipesManager;
    private final StructureSettingsManager structureSettingsManager;

    public InteractStructureLis(ActiveStructuresManager activeStructuresManager, RecipesManager recipesManager, StructureSettingsManager structureSettingsManager) {
        this.activeStructuresManager = activeStructuresManager;
        this.recipesManager = recipesManager;
        this.structureSettingsManager = structureSettingsManager;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInteract(PlayerInteractEvent ev) {
        if (ev.isCancelled() || ev.useItemInHand() == Event.Result.DENY || ev.useInteractedBlock() == Event.Result.DENY || ev.getAction() != Action.RIGHT_CLICK_BLOCK || !MCUtils.isMainHand(ev)) {
            return;
        }
        Block block = ev.getClickedBlock();
        if (block == null) {
            return;
        }
        ActiveStructure activeStructure = this.activeStructuresManager.getStructure(this.activeStructuresManager.getStructureID(block));
        if (activeStructure == null) {
            return;
        }
        ev.setCancelled(true);
        ev.setUseInteractedBlock(Event.Result.DENY);
        ev.setUseItemInHand(Event.Result.DENY);
        Player player = ev.getPlayer();
        activeStructure.onInteract(player, block.getLocation(), ev.getItem(), this.recipesManager, this.structureSettingsManager);
    }
}

