/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Listeners;

import com.deadshotmdf.MagicalCrafting.ConfigSettings;
import com.deadshotmdf.MagicalCrafting.MC;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class UpdateChecker
implements Listener {
    private static final String url = "https://api.spigotmc.org/legacy/update.php?resource=119136/";
    private static final String updateURL = "https://www.spigotmc.org/resources/magicalcrafting.119136/";
    private final MC main;

    public UpdateChecker(MC main) {
        this.main = main;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent ev) {
        if (!ConfigSettings.getUpdateNotifications()) {
            return;
        }
        Player player = ev.getPlayer();
        if (!player.isOp() && !player.hasPermission("magicalcrafting.managestructure")) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> this.checkUpdate(player));
    }

    private void checkUpdate(Player player) {
        try {
            String localVersion = this.main.getDescription().getVersion();
            HttpsURLConnection connection = (HttpsURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("GET");
            String raw = new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();
            if (!localVersion.equalsIgnoreCase(raw.contains("-") ? raw.split("-")[0].trim() : raw)) {
                Bukkit.getScheduler().runTask((Plugin)this.main, () -> this.sendMessage(player));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void sendMessage(Player player) {
        if (player != null && player.isOnline()) {
            player.sendMessage(ChatColor.GREEN + "A new version of magical crafting is available at: " + updateURL);
        }
    }
}

