/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting;

import com.deadshotmdf.MagicalCrafting.Commands.AddRemoveFriendCommand;
import com.deadshotmdf.MagicalCrafting.Commands.OpenAltarSettingsGUICmd;
import com.deadshotmdf.MagicalCrafting.Commands.ReloadConfigCommand;
import com.deadshotmdf.MagicalCrafting.Commands.Structure_And_Recipe.CraftStructureCommand;
import com.deadshotmdf.MagicalCrafting.Commands.Structure_And_Recipe.CreateRemoveRecipeCommand;
import com.deadshotmdf.MagicalCrafting.Commands.Structure_And_Recipe.EditRecipeCommand;
import com.deadshotmdf.MagicalCrafting.Commands.Structure_And_Recipe.ListRecipesCommand;
import com.deadshotmdf.MagicalCrafting.Commands.Structure_And_Recipe.SeeRecipesForStructureCommand;
import com.deadshotmdf.MagicalCrafting.Commands.Structure_And_Recipe.StructureAddRemoveRecipeCommand;
import com.deadshotmdf.MagicalCrafting.ConfigSettings;
import com.deadshotmdf.MagicalCrafting.Listeners.CompleteStructureLis;
import com.deadshotmdf.MagicalCrafting.Listeners.CustomInvLis;
import com.deadshotmdf.MagicalCrafting.Listeners.Destroy.StructureDestructionLis;
import com.deadshotmdf.MagicalCrafting.Listeners.Destroy.StructureDestructionLisNew;
import com.deadshotmdf.MagicalCrafting.Listeners.InteractStructureLis;
import com.deadshotmdf.MagicalCrafting.Listeners.PlayerJoinLis;
import com.deadshotmdf.MagicalCrafting.Listeners.SelectPositionsLis;
import com.deadshotmdf.MagicalCrafting.Listeners.UpdateChecker;
import com.deadshotmdf.MagicalCrafting.Managers.ActiveStructuresManager;
import com.deadshotmdf.MagicalCrafting.Managers.FancyManager;
import com.deadshotmdf.MagicalCrafting.Managers.GUIManager;
import com.deadshotmdf.MagicalCrafting.Managers.RecipesManager;
import com.deadshotmdf.MagicalCrafting.Managers.StructureManager;
import com.deadshotmdf.MagicalCrafting.Managers.StructureSettingsManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class MC
extends JavaPlugin {
    private RecipesManager recipesManager;
    private StructureManager structureManager;
    private ActiveStructuresManager activeStructuresManager;
    private FancyManager fancyManager;
    private GUIManager guiManager;
    private StructureSettingsManager structureSettingsManager;

    public void onEnable() {
        this.saveDefaultConfig();
        ConfigSettings.reloadConfig(this);
        this.recipesManager = new RecipesManager(this);
        this.structureManager = new StructureManager(this, this.recipesManager);
        this.recipesManager.setStructureManager(this.structureManager);
        this.activeStructuresManager = new ActiveStructuresManager(this, this.structureManager, this.recipesManager);
        this.recipesManager.setActiveStructuresManager(this.activeStructuresManager);
        this.fancyManager = new FancyManager();
        this.guiManager = new GUIManager(this);
        this.structureSettingsManager = new StructureSettingsManager(this);
        PluginManager pm = Bukkit.getPluginManager();
        pm.registerEvents((Listener)new SelectPositionsLis(this.structureManager), (Plugin)this);
        pm.registerEvents((Listener)new CompleteStructureLis(this.structureManager, this.activeStructuresManager, this.fancyManager), (Plugin)this);
        pm.registerEvents((Listener)new InteractStructureLis(this.activeStructuresManager, this.recipesManager, this.structureSettingsManager), (Plugin)this);
        pm.registerEvents((Listener)new StructureDestructionLis(this, this.activeStructuresManager, this.fancyManager), (Plugin)this);
        pm.registerEvents((Listener)new CustomInvLis(this.guiManager), (Plugin)this);
        pm.registerEvents((Listener)new UpdateChecker(this), (Plugin)this);
        pm.registerEvents((Listener)new PlayerJoinLis(this.structureSettingsManager), (Plugin)this);
        try {
            pm.registerEvents((Listener)new StructureDestructionLisNew(this, this.activeStructuresManager, this.fancyManager), (Plugin)this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.getCommand("craftstructure").setExecutor((CommandExecutor)new CraftStructureCommand(this.structureManager));
        this.getCommand("crrecipe").setExecutor((CommandExecutor)new CreateRemoveRecipeCommand(this, this.recipesManager));
        this.getCommand("lrecipe").setExecutor((CommandExecutor)new ListRecipesCommand(this.recipesManager));
        this.getCommand("editrecipe").setExecutor((CommandExecutor)new EditRecipeCommand(this.recipesManager, this.guiManager));
        this.getCommand("magicalcrafting").setExecutor((CommandExecutor)new ReloadConfigCommand(this, this.structureSettingsManager, this.guiManager, this.recipesManager));
        this.getCommand("scrr").setExecutor((CommandExecutor)new StructureAddRemoveRecipeCommand(this.recipesManager, this.structureManager, this.activeStructuresManager));
        this.getCommand("srstructure").setExecutor((CommandExecutor)new SeeRecipesForStructureCommand(this.structureManager));
        this.getCommand("mcarfriend").setExecutor((CommandExecutor)new AddRemoveFriendCommand(this, this.structureSettingsManager));
        this.getCommand("oasgui").setExecutor((CommandExecutor)new OpenAltarSettingsGUICmd(this.structureSettingsManager, this.guiManager));
    }

    public void onDisable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.closeInventory();
        }
        this.structureManager.saveAll();
        this.recipesManager.saveAll();
        this.activeStructuresManager.saveAll();
        this.structureSettingsManager.saveAll();
    }
}

