/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Managers;

import com.deadshotmdf.MagicalCrafting.MC;
import com.deadshotmdf.MagicalCrafting.Managers.RecipesManager;
import com.deadshotmdf.MagicalCrafting.Managers.StructureManager;
import com.deadshotmdf.MagicalCrafting.Objects.Enums.Rotation;
import com.deadshotmdf.MagicalCrafting.Objects.Enums.StructureBlockType;
import com.deadshotmdf.MagicalCrafting.Objects.Holders.BlockDataHolder;
import com.deadshotmdf.MagicalCrafting.Objects.Holders.CustomCoords;
import com.deadshotmdf.MagicalCrafting.Objects.Misc.ItemWrapper;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.ActiveStructure;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.CraftStructure;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.MultiInformationHolder;
import com.deadshotmdf.MagicalCrafting.Utils.MCUtils;
import com.deadshotmdf.MagicalCrafting.Utils.MCUtilsCompat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class ActiveStructuresManager
extends MultiInformationHolder<ActiveStructure> {
    private final MC main;
    private final StructureManager structureManager;

    public ActiveStructuresManager(MC main, StructureManager structureManager, RecipesManager recipesManager) {
        super(main, "builds", recipesManager, ActiveStructure::new);
        this.main = main;
        this.structureManager = structureManager;
    }

    public UUID getStructureID(Block block) {
        return block == null ? null : MCUtils.getUUID(block.getMetadata("magic_craft-in.bl0ck-_iden_-"));
    }

    public ActiveStructure getStructure(UUID uuid) {
        return uuid == null ? null : (ActiveStructure)this.getValueById(uuid.toString());
    }

    public void addActiveStructure(Player player, HashMap<Block, StructureBlockType> blocks, String baseId) {
        String uuid = this.getUUID();
        HashSet<Location> locations = new HashSet<Location>();
        HashMap<Location, ItemWrapper> pedestals = new HashMap<Location, ItemWrapper>();
        Location core = null;
        for (Map.Entry<Block, StructureBlockType> entries : blocks.entrySet()) {
            Location loc = entries.getKey().getLocation();
            StructureBlockType blockType = entries.getValue();
            locations.add(loc);
            if (blockType == StructureBlockType.CORE) {
                core = loc;
                continue;
            }
            if (blockType != StructureBlockType.PEDESTAL) continue;
            pedestals.put(loc, new ItemWrapper(null));
        }
        ActiveStructure activeStructure = new ActiveStructure(this.main, baseId, uuid, player.getUniqueId(), locations, pedestals, core);
        this.put(uuid, activeStructure);
    }

    public Object[] checkForStructureCompletion(Location placedLocation, Material material) {
        for (CraftStructure structure : this.structureManager.getValues()) {
            if (!structure.containsMaterial(material)) continue;
            int width = structure.getWidth();
            int height = structure.getHeight();
            int depth = structure.getDepth();
            for (Rotation rotation : Rotation.values()) {
                for (int x = -width + 1; x < width; ++x) {
                    for (int y = -height + 1; y < height; ++y) {
                        for (int z = -depth + 1; z < depth; ++z) {
                            Location potentialCenter = placedLocation.clone().add((double)x, (double)y, (double)z);
                            HashMap<Block, StructureBlockType> matchedBlocks = this.isStructureCompleteAtLocation(potentialCenter, structure, rotation);
                            if (matchedBlocks == null) continue;
                            return new Object[]{matchedBlocks, structure.getId()};
                        }
                    }
                }
            }
        }
        return null;
    }

    private HashMap<Block, StructureBlockType> isStructureCompleteAtLocation(Location centerLocation, CraftStructure structure, Rotation rotation) {
        HashMap<Block, StructureBlockType> matchedBlocks = new HashMap<Block, StructureBlockType>();
        for (CustomCoords offset : structure.getAllOffsets()) {
            Location checkLocation = this.applyRotation(centerLocation.clone(), offset, rotation);
            Block block = checkLocation.getBlock();
            BlockDataHolder expectedData = structure.getBlockDataAtCoords(offset);
            if (!this.structureManager.isValid(block.getType()) || block.hasMetadata("magic_craft-in.bl0ck-_iden_-") || !this.doesBlockMatch(block, expectedData)) {
                return null;
            }
            if (structure.getCore().equals(offset)) {
                matchedBlocks.put(block, StructureBlockType.CORE);
                continue;
            }
            if (structure.isPedestal(offset)) {
                matchedBlocks.put(block, StructureBlockType.PEDESTAL);
                continue;
            }
            matchedBlocks.put(block, StructureBlockType.BUILD);
        }
        return matchedBlocks;
    }

    private Location applyRotation(Location baseLocation, CustomCoords offset, Rotation rotation) {
        int x = offset.getX();
        int y = offset.getY();
        int z = offset.getZ();
        switch (rotation) {
            case ROTATE_90: {
                return baseLocation.add((double)(-z), (double)y, (double)x);
            }
            case ROTATE_180: {
                return baseLocation.add((double)(-x), (double)y, (double)(-z));
            }
            case ROTATE_270: {
                return baseLocation.add((double)z, (double)y, (double)(-x));
            }
        }
        return baseLocation.add((double)x, (double)y, (double)z);
    }

    private boolean doesBlockMatch(Block block, BlockDataHolder expectedData) {
        if (MCUtils.IS_NEW) {
            return MCUtilsCompat.isSame(block, expectedData);
        }
        return block.getState().getData().equals((Object)expectedData.getMaterialDataOld());
    }

    private String getUUID() {
        String uuid = UUID.randomUUID().toString().toLowerCase();
        return this.containsKey(uuid) ? this.getUUID() : uuid;
    }
}

