/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Managers;

import com.deadshotmdf.MagicalCrafting.Objects.Enums.StructureBlockType;
import com.deadshotmdf.MagicalCrafting.Utils.NewParticlesUtil;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public class FancyManager {
    private boolean canUseNewParticles;

    public FancyManager() {
        try {
            Class.forName("org.bukkit.Particle");
            this.canUseNewParticles = true;
        }
        catch (Throwable e) {
            this.canUseNewParticles = false;
        }
    }

    public void completeStructure(HashMap<Block, StructureBlockType> blocks) {
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        World world = blocks.entrySet().iterator().next().getKey().getWorld();
        for (Map.Entry<Block, StructureBlockType> entries : blocks.entrySet()) {
            Location location = entries.getKey().getLocation().clone();
            StructureBlockType structureBlockType = entries.getValue();
            if (structureBlockType == StructureBlockType.CORE) {
                world.strikeLightningEffect(location);
                continue;
            }
            if (structureBlockType != StructureBlockType.PEDESTAL) continue;
            if (this.canUseNewParticles) {
                NewParticlesUtil.playNewParticles(world, location.add(0.5, 0.0, 0.5));
                continue;
            }
            world.playEffect(location.add(0.5, 0.0, 0.5), Effect.valueOf((String)"VILLAGER_THUNDERCLOUD"), 0);
        }
    }

    public void onStructureDestroy(Location location) {
    }
}

