/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Managers;

import com.deadshotmdf.MagicalCrafting.ConfigSettings;
import com.deadshotmdf.MagicalCrafting.MC;
import com.deadshotmdf.MagicalCrafting.Objects.Enums.ItemIds;
import com.deadshotmdf.MagicalCrafting.Objects.GUI.AltarSettings.AltarSettingsGUI;
import com.deadshotmdf.MagicalCrafting.Objects.GUI.CustomGUI;
import com.deadshotmdf.MagicalCrafting.Objects.GUI.Recipe.MainGUI;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.MagicalRecipe;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.StructureSettings;
import com.deadshotmdf.MagicalCrafting.Utils.MCUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class GUIManager {
    private final MC main;
    private final HashMap<Inventory, CustomGUI> guis;
    private final HashMap<ItemIds, ItemStack> items;
    private final HashMap<ItemIds, List<String>> lores;
    private final HashMap<UUID, Inventory> awaitingResponse;
    private final HashMap<String, Inventory> openedInventories;

    public GUIManager(MC main) {
        this.main = main;
        this.guis = new HashMap();
        this.items = new HashMap();
        this.lores = new HashMap();
        this.awaitingResponse = new HashMap();
        this.openedInventories = new HashMap();
        this.reloadConfig(main.getConfig());
    }

    public void openEditRecipeInventory(Player player, String id, MagicalRecipe magicalRecipe) {
        Inventory inventory = this.openedInventories.get(id);
        if (inventory != null) {
            player.openInventory(inventory);
            return;
        }
        MainGUI mainGUI = new MainGUI(this.main, this, magicalRecipe, id);
        this.registerGUI(mainGUI);
        this.openedInventories.put(id, mainGUI.getInventory());
        player.openInventory(mainGUI.getInventory());
    }

    public void openAltarSettingsInventory(Player player, StructureSettings structureSettings) {
        AltarSettingsGUI settingsGUI = new AltarSettingsGUI(this, structureSettings);
        this.registerGUI(settingsGUI);
        player.openInventory(settingsGUI.getInventory());
    }

    public void registerGUI(CustomGUI gui) {
        this.guis.put(gui.getInventory(), gui);
    }

    public void unregisterGUI(CustomGUI gui) {
        this.unregisterGUI(gui.getInventory());
    }

    public void removeOpenedGUI(String id) {
        this.openedInventories.remove(id);
    }

    public void unregisterGUI(Inventory inv) {
        this.guis.remove(inv);
    }

    public CustomGUI getGUI(Inventory inv) {
        return inv == null ? null : this.guis.get(inv);
    }

    public void onInventoryOpen(InventoryOpenEvent ev) {
        CustomGUI gui = this.getGUI(ev.getInventory());
        if (gui != null) {
            gui.onOpen(ev);
        }
    }

    public void onInventoryClick(InventoryClickEvent ev) {
        CustomGUI gui = this.getGUI(ev.getInventory());
        if (gui != null) {
            gui.onClick(ev);
        }
    }

    public void onInventoryClose(InventoryCloseEvent ev) {
        CustomGUI gui = this.getGUI(ev.getInventory());
        if (gui != null) {
            gui.onClose(ev);
        }
    }

    public void onInventoryDrag(InventoryDragEvent ev) {
        CustomGUI gui = this.getGUI(ev.getInventory());
        if (gui != null) {
            ev.setCancelled(true);
        }
    }

    private void onPlayerAction(Player player, String message, boolean receive) {
        UUID uuid = player.getUniqueId();
        Inventory inv = this.awaitingResponse.remove(uuid);
        if (inv == null) {
            return;
        }
        CustomGUI gui = this.getGUI(inv);
        if (gui == null) {
            return;
        }
        if (receive) {
            Bukkit.getScheduler().runTask((Plugin)this.main, () -> gui.receiveResponse(player, message));
        } else {
            gui.killInventory();
        }
    }

    public void onPlayerChat(AsyncPlayerChatEvent ev) {
        Player player = ev.getPlayer();
        if (!this.awaitingResponse.containsKey(player.getUniqueId())) {
            return;
        }
        ev.setCancelled(true);
        this.onPlayerAction(player, ev.getMessage(), true);
    }

    public void addPlayerAwait(UUID uuid, Inventory inv) {
        this.awaitingResponse.put(uuid, inv);
    }

    public void onPlayerQuit(Player player) {
        this.onPlayerAction(player, null, false);
    }

    public ItemStack getItemStackReplaced(ItemIds id, String[] toReplace, String[] replace) {
        ItemStack item = this.items.get((Object)id);
        if (item == null) {
            return null;
        }
        ItemMeta meta = (item = item.clone()).getItemMeta();
        if (meta == null || meta.getLore() == null || meta.getLore().isEmpty()) {
            return item;
        }
        meta.setLore(ConfigSettings.replace(this.lores.get((Object)id), toReplace, replace));
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack addMoreLore(ItemStack item, ItemIds id, String[] toReplace, String[] replace) {
        if (item == null) {
            return null;
        }
        ItemMeta meta = (item = item.clone()).getItemMeta();
        if (meta == null) {
            return null;
        }
        List more = meta.getLore();
        more = more != null ? more : new LinkedList();
        more.add(" ");
        more.addAll(ConfigSettings.replace(this.lores.get((Object)id), toReplace, replace));
        meta.setLore(more);
        item.setItemMeta(meta);
        return item;
    }

    public void reloadConfig(FileConfiguration config) {
        this.items.clear();
        this.lores.clear();
        ConfigurationSection sec = config.getConfigurationSection("items");
        if (sec == null) {
            return;
        }
        Set keys = sec.getKeys(false);
        if (keys.isEmpty()) {
            return;
        }
        for (String key : keys) {
            ItemIds id = ItemIds.getItemId(key);
            if (id == null) continue;
            String glass = config.getString("items." + key + ".material", "DIRT").toUpperCase();
            Material material = Material.getMaterial((String)glass);
            if (material == null || glass.endsWith("_STAINED_GLASS_PANE")) {
                material = Material.getMaterial((String)"STAINED_GLASS_PANE");
            }
            if (material == null) continue;
            String name = config.getString("items." + key + ".name");
            List<String> lore = ConfigSettings.color(config.getStringList("items." + key + ".lore"));
            int amount = config.getInt("items." + key + ".amount", 1);
            short data = (short)config.getInt("items." + key + ".materialData");
            int customModelData = config.getInt("items." + key + ".customModelData");
            boolean hasGlow = config.getBoolean("items." + key + ".hasGlow");
            amount = Math.max(1, amount);
            data = (short)Math.max(0, data);
            this.items.put(id, MCUtils.createItem(name, lore, amount, data, material, hasGlow, customModelData));
            this.lores.put(id, lore);
        }
    }
}

