/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Managers;

import com.deadshotmdf.MagicalCrafting.MC;
import com.deadshotmdf.MagicalCrafting.Managers.ActiveStructuresManager;
import com.deadshotmdf.MagicalCrafting.Managers.StructureManager;
import com.deadshotmdf.MagicalCrafting.Objects.Enums.SkipChecks;
import com.deadshotmdf.MagicalCrafting.Objects.Misc.ItemWrapper;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.ActiveStructure;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.CraftStructure;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.MagicalRecipe;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.MultiInformationHolder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;

public class RecipesManager
extends MultiInformationHolder<MagicalRecipe> {
    private StructureManager structureManager;
    private ActiveStructuresManager activeStructuresManager;

    public RecipesManager(MC main) {
        super(main, "recipes", null, MagicalRecipe::new);
        this.reloadConfig(main.getConfig());
    }

    public void removeRecipe(String id) {
        if (id == null) {
            return;
        }
        for (CraftStructure structure : this.structureManager.getValues()) {
            structure.getRecipes().removeIf(k -> k.getId().equalsIgnoreCase(id));
        }
        for (ActiveStructure activeStructure : this.activeStructuresManager.getValues()) {
            if (!activeStructure.getCurrentRecipe().getId().equalsIgnoreCase(id)) continue;
            activeStructure.stopRecipe();
        }
    }

    public void createRecipe(MC main, String id) {
        this.put(id, new MagicalRecipe(main, id, null));
    }

    public void reloadConfig(FileConfiguration config) {
        ItemWrapper.CHECKS_TO_SKIP.clear();
        List keys = config.getStringList("item-check-skips");
        boolean b = false;
        for (String key : keys) {
            SkipChecks skip = SkipChecks.getFromString(key);
            if (skip == null) continue;
            ItemWrapper.CHECKS_TO_SKIP.add(skip);
            if (!skip.is_from_metadata()) continue;
            b = true;
        }
        ItemWrapper.METADATA_SKIP_CHECKS = b;
        this.getValues().forEach(MagicalRecipe::onReload);
    }

    public MagicalRecipe getRecipeByItems(String id, ItemWrapper core, Collection<ItemWrapper> pedestals) {
        Set<MagicalRecipe> recipes = this.structureManager.getRecipesForStructure(id);
        if (recipes == null || recipes.isEmpty()) {
            return null;
        }
        block0: for (MagicalRecipe magicalRecipe : recipes) {
            if (magicalRecipe.getPrimaryItemStack() == null && magicalRecipe.getIngredients().isEmpty()) continue;
            int amount = magicalRecipe.getIngredients().size();
            ItemWrapper prime = magicalRecipe.getPrimaryItemStack();
            if (prime.getItem() == null && core.getItem() != null || prime.getItem() != null && !prime.equals(core)) continue;
            for (ItemWrapper pedestal : pedestals) {
                if (pedestal.getItem() == null) continue;
                if (!magicalRecipe.getIngredients().contains(pedestal)) continue block0;
                if (--amount >= 1) continue;
                break;
            }
            if (amount > 0) continue;
            return magicalRecipe;
        }
        return null;
    }

    public void setStructureManager(StructureManager structureManager) {
        this.structureManager = structureManager;
    }

    public void setActiveStructuresManager(ActiveStructuresManager activeStructuresManager) {
        this.activeStructuresManager = activeStructuresManager;
    }
}

