/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Managers;

import com.deadshotmdf.MagicalCrafting.ConfigSettings;
import com.deadshotmdf.MagicalCrafting.MC;
import com.deadshotmdf.MagicalCrafting.Managers.RecipesManager;
import com.deadshotmdf.MagicalCrafting.Objects.Holders.BlockDataHolder;
import com.deadshotmdf.MagicalCrafting.Objects.Holders.CustomCoords;
import com.deadshotmdf.MagicalCrafting.Objects.Holders.PositionPair;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.CraftStructure;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.MagicalRecipe;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.MultiInformationHolder;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class StructureManager
extends MultiInformationHolder<CraftStructure> {
    public static final String CORE_METADATA = "core_metad.MC-ata_magic_-craft";
    public static final String PEDESTAL_METADATA = "pedestal_metadata_mag-MC.ic_-craft";
    public static final String BLOCK_IDENT = "magic_craft-in.bl0ck-_iden_-";
    private final HashMap<UUID, PositionPair> selectedPositions = new HashMap();
    private final EnumSet<Material> materials;
    private final Logger logger;

    public StructureManager(MC main, RecipesManager recipesManager) {
        super(main, "structures", recipesManager, CraftStructure::new);
        this.logger = main.getLogger();
        this.materials = EnumSet.noneOf(Material.class);
        this.loadMaterials();
    }

    public boolean isValid(Material material) {
        return this.materials.contains(material);
    }

    public void addPosition(UUID player, Location location, boolean pos1) {
        PositionPair positionPair = this.selectedPositions.computeIfAbsent(player, k -> new PositionPair());
        if (pos1) {
            positionPair.setLocation1(location);
        } else {
            positionPair.setLocation2(location);
        }
    }

    public Set<MagicalRecipe> getRecipesForStructure(String id) {
        if (id == null) {
            return null;
        }
        CraftStructure structure = (CraftStructure)this.getValueById(id);
        if (structure == null) {
            return null;
        }
        return structure.getRecipes();
    }

    public void removeStructure(Player player, String id) {
        if (!this.containsKey(id = id.toLowerCase())) {
            player.sendMessage(ConfigSettings.getInvalidId(id));
            return;
        }
        player.sendMessage(ConfigSettings.getStructureRemoved(id));
        this.remove(id);
        String i = id;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> this.removeFile(i));
    }

    public void markBlock(String id, Block block, Player player, String message, String message2) {
        if (!block.hasMetadata(id)) {
            block.setMetadata(id, (MetadataValue)new FixedMetadataValue((Plugin)this.main, (Object)true));
            player.sendMessage(message);
        } else {
            block.removeMetadata(id, (Plugin)this.main);
            player.sendMessage(message2);
        }
    }

    public void loadMaterials() {
        this.materials.clear();
        for (CraftStructure craftStructure : this.getValues()) {
            this.materials.addAll(craftStructure.getMaterialsClone());
        }
    }

    public void createStructure(Player player, String id) {
        if (this.containsKey(id = id.toLowerCase())) {
            player.sendMessage(ConfigSettings.getSameId(id));
            return;
        }
        PositionPair positionPair = this.selectedPositions.getOrDefault(player.getUniqueId(), new PositionPair());
        Location point1 = positionPair.getLocation1();
        Location point2 = positionPair.getLocation2();
        World world = null;
        if (point1 == null || point2 == null || (world = point1.getWorld()) == null || !world.equals(point2.getWorld())) {
            player.sendMessage(ConfigSettings.getInvalidLocations());
            return;
        }
        List<Location> structureBlocks = StructureManager.getLocations(point1, point2);
        if (structureBlocks.isEmpty()) {
            player.sendMessage(ConfigSettings.getNoBlock());
            return;
        }
        structureBlocks.sort((loc1, loc2) -> {
            int cmpX = Integer.compare(loc1.getBlockX(), loc2.getBlockX());
            if (cmpX != 0) {
                return cmpX;
            }
            int cmpZ = Integer.compare(loc1.getBlockZ(), loc2.getBlockZ());
            if (cmpZ != 0) {
                return cmpZ;
            }
            return Integer.compare(loc1.getBlockY(), loc2.getBlockY());
        });
        int midIndex = structureBlocks.size() / 2;
        Location center = structureBlocks.get(midIndex);
        int centerX = center.getBlockX();
        int centerZ = center.getBlockZ();
        int lowestY = Integer.MAX_VALUE;
        for (Location loc : structureBlocks) {
            if (loc.getBlockX() != centerX || loc.getBlockZ() != centerZ || loc.getBlockY() >= lowestY) continue;
            lowestY = loc.getBlockY();
            center = loc;
        }
        this.logger.info("Center of the structure: " + center.getBlock());
        CraftStructure craftStructure = new CraftStructure(this.main, id, null);
        int amount = 0;
        for (Location loc : structureBlocks) {
            ++amount;
            int offsetX = loc.getBlockX() - center.getBlockX();
            int offsetY = loc.getBlockY() - center.getBlockY();
            int offsetZ = loc.getBlockZ() - center.getBlockZ();
            Block block = loc.getBlock();
            craftStructure.addBlock(new CustomCoords(offsetX, offsetY, offsetZ), new BlockDataHolder(block, block.getState().getData()), block.hasMetadata(CORE_METADATA), block.hasMetadata(PEDESTAL_METADATA));
        }
        if (craftStructure.getCore() == null) {
            player.sendMessage(ConfigSettings.getNoCore());
            return;
        }
        this.put(id, craftStructure);
        player.sendMessage(ConfigSettings.getStructureCreated(id, amount, craftStructure.pedestalSize()));
        this.loadMaterials();
    }

    private static List<Location> getLocations(Location point1, Location point2) {
        ArrayList<Location> structureBlocks = new ArrayList<Location>();
        World world = point1.getWorld();
        int minX = Math.min(point1.getBlockX(), point2.getBlockX());
        int maxX = Math.max(point1.getBlockX(), point2.getBlockX());
        int minY = Math.min(point1.getBlockY(), point2.getBlockY());
        int maxY = Math.max(point1.getBlockY(), point2.getBlockY());
        int minZ = Math.min(point1.getBlockZ(), point2.getBlockZ());
        int maxZ = Math.max(point1.getBlockZ(), point2.getBlockZ());
        for (int x = minX + 1; x < maxX; ++x) {
            for (int y = minY + 1; y < maxY; ++y) {
                for (int z = minZ + 1; z < maxZ; ++z) {
                    Location loc = new Location(world, (double)x, (double)y, (double)z);
                    if (loc.getBlock().getType() == Material.AIR) continue;
                    structureBlocks.add(loc);
                }
            }
        }
        return structureBlocks;
    }

    private void removeFile(String id) {
        File file = new File(this.main.getDataFolder(), "structures/" + id + ".yml");
        if (file.exists()) {
            file.delete();
        }
    }
}

