/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Managers;

import com.deadshotmdf.MagicalCrafting.ConfigSettings;
import com.deadshotmdf.MagicalCrafting.MC;
import com.deadshotmdf.MagicalCrafting.Objects.Enums.AltarAccessStatus;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.MultiInformationHolder;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.StructureSettings;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class StructureSettingsManager
extends MultiInformationHolder<StructureSettings> {
    private final HashMap<String, UUID> offlinePlayers = new HashMap();

    public StructureSettingsManager(MC main) {
        super(main, "structuresettings", null, StructureSettings::new);
        for (OfflinePlayer player : Bukkit.getOnlinePlayers()) {
            if (player == null) continue;
            this.offlinePlayers.put(player.getName(), player.getUniqueId());
        }
    }

    public void addOfflinePlayer(String name, UUID uuid) {
        if (name != null && uuid != null) {
            this.offlinePlayers.put(name.toLowerCase(), uuid);
        }
    }

    public UUID getOfflinePlayer(String name) {
        return this.offlinePlayers.get(name != null ? name.toLowerCase() : "NULL&*");
    }

    public void reloadConfig() {
        if (ConfigSettings.getOnlyOwnerCanInteract()) {
            this.getValues().forEach(value -> value.setAccessStatus(AltarAccessStatus.PRIVATE, true));
        } else {
            this.getValues().forEach(StructureSettings::setBackToOldStatus);
        }
    }

    @Override
    @Deprecated
    public StructureSettings getValueById(String id) {
        throw new UnsupportedOperationException("Don't use it. Use getValueByIdOrNew instead.");
    }

    @Override
    @Deprecated
    public StructureSettings remove(String id) {
        throw new UnsupportedOperationException("Cannot remove settings profile");
    }
}

