/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Objects.GUI.AltarSettings;

import com.deadshotmdf.MagicalCrafting.ConfigSettings;
import com.deadshotmdf.MagicalCrafting.Managers.GUIManager;
import com.deadshotmdf.MagicalCrafting.Objects.Enums.AltarAccessStatus;
import com.deadshotmdf.MagicalCrafting.Objects.Enums.ItemIds;
import com.deadshotmdf.MagicalCrafting.Objects.GUI.CustomGUI;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.StructureSettings;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class AltarSettingsGUI
implements CustomGUI {
    private GUIManager guiManager;
    private Inventory inventory;
    private StructureSettings structureSettings;

    public AltarSettingsGUI(GUIManager guiManager, StructureSettings structureSettings) {
        this.guiManager = guiManager;
        this.inventory = Bukkit.createInventory(null, (int)9, (String)ConfigSettings.getAltarSettingsInventoryName());
        this.structureSettings = structureSettings;
        this.refreshInventory();
    }

    @Override
    public void onOpen(InventoryOpenEvent ev) {
    }

    @Override
    public void onClick(InventoryClickEvent ev) {
        ev.setCancelled(true);
        if (ev.getRawSlot() != 4) {
            return;
        }
        AltarAccessStatus accessStatus = ConfigSettings.getOnlyOwnerCanInteract() ? AltarAccessStatus.PRIVATE : this.structureSettings.getNextAlterStatus();
        this.structureSettings.setAccessStatus(accessStatus, false);
        this.refreshInventory();
    }

    @Override
    public void onClose(InventoryCloseEvent ev) {
        this.killInventory();
    }

    @Override
    public void refreshInventory() {
        this.inventory.clear();
        ItemStack filler = this.guiManager.getItemStackReplaced(ItemIds.FILLER, null, null);
        for (int i = 0; i < 9; ++i) {
            this.inventory.setItem(i, filler);
        }
        this.inventory.setItem(4, this.guiManager.getItemStackReplaced(ItemIds.STRUCTURE_ACCESS_MODE, new String[]{"{mode}"}, new String[]{this.structureSettings.getAccessStatus().getMessage()}));
    }

    @Override
    public void receiveResponse(Player player, String message) {
    }

    @Override
    public void killInventory() {
        this.guiManager.unregisterGUI(this);
        this.guiManager = null;
        this.structureSettings = null;
    }

    @Override
    public Inventory getInventory() {
        return this.inventory;
    }
}

