/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Objects.GUI.Recipe;

import com.deadshotmdf.MagicalCrafting.ConfigSettings;
import com.deadshotmdf.MagicalCrafting.Objects.GUI.CustomGUI;
import com.deadshotmdf.MagicalCrafting.Objects.GUI.Recipe.MainGUI;
import com.deadshotmdf.MagicalCrafting.Objects.Misc.ItemWrapper;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class IngredientsGUI
implements CustomGUI {
    private final Set<ItemWrapper> ingredients;
    private final Inventory inventory = Bukkit.createInventory(null, (int)54, (String)ConfigSettings.getRecipeIngredientsGuiTitle());
    private MainGUI parent;

    public IngredientsGUI(Set<ItemWrapper> ingredients, MainGUI parent) {
        this.ingredients = ingredients;
        this.parent = parent;
        this.refreshInventory();
    }

    @Override
    public void onOpen(InventoryOpenEvent ev) {
        this.refreshInventory();
    }

    @Override
    public void onClick(InventoryClickEvent ev) {
    }

    @Override
    public void onClose(InventoryCloseEvent ev) {
        this.ingredients.clear();
        for (ItemStack item : this.inventory.getContents()) {
            if (item == null) continue;
            this.ingredients.add(new ItemWrapper(item));
        }
        this.parent.openParent((Player)ev.getPlayer());
    }

    @Override
    public void refreshInventory() {
        this.inventory.clear();
        int i = 0;
        for (ItemWrapper item : this.ingredients) {
            if (i >= 54) {
                return;
            }
            this.inventory.setItem(i++, item.getItem());
        }
    }

    @Override
    public void receiveResponse(Player player, String message) {
    }

    @Override
    public void killInventory() {
    }

    @Override
    public Inventory getInventory() {
        return this.inventory;
    }

    protected void removeParent() {
        this.parent = null;
    }
}

