/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Objects.GUI.Recipe;

import com.deadshotmdf.MagicalCrafting.ConfigSettings;
import com.deadshotmdf.MagicalCrafting.MC;
import com.deadshotmdf.MagicalCrafting.Managers.GUIManager;
import com.deadshotmdf.MagicalCrafting.Objects.Enums.ItemIds;
import com.deadshotmdf.MagicalCrafting.Objects.GUI.CustomGUI;
import com.deadshotmdf.MagicalCrafting.Objects.GUI.Recipe.IngredientsGUI;
import com.deadshotmdf.MagicalCrafting.Objects.Misc.ItemWrapper;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.MagicalRecipe;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MainGUI
implements CustomGUI {
    private MC main;
    private GUIManager guiManager;
    private MagicalRecipe magicalRecipe;
    private final Inventory inventory;
    private final IngredientsGUI ingredientsPage;
    private final String id;
    private boolean changingViews;

    public MainGUI(MC main, GUIManager guiManager, MagicalRecipe magicalRecipe, String id) {
        this.main = main;
        this.guiManager = guiManager;
        this.inventory = Bukkit.createInventory(null, (int)9, (String)ConfigSettings.getRecipeMainGuiTitle());
        this.magicalRecipe = magicalRecipe;
        this.id = id;
        this.ingredientsPage = new IngredientsGUI(magicalRecipe.getIngredients(), this);
        guiManager.registerGUI(this.ingredientsPage);
        this.refreshInventory();
    }

    @Override
    public void onOpen(InventoryOpenEvent ev) {
        this.refreshInventory();
    }

    @Override
    public void onClick(InventoryClickEvent ev) {
        boolean isLeft;
        ev.setCancelled(true);
        int rawSlot = ev.getRawSlot();
        Player player = (Player)ev.getWhoClicked();
        if (rawSlot == 1) {
            this.changingViews = true;
            player.closeInventory();
            player.openInventory(this.ingredientsPage.getInventory());
            return;
        }
        ClickType clickType = ev.getClick();
        boolean bl = isLeft = clickType == ClickType.LEFT;
        if (rawSlot == 3 && this.magicalRecipe.getPrimaryItemStack().getItem() != null) {
            if (clickType == ClickType.RIGHT) {
                player.getInventory().addItem(new ItemStack[]{this.magicalRecipe.getPrimaryItemStack().getItem().clone()});
                return;
            }
            if (!isLeft) {
                return;
            }
            this.magicalRecipe.setPrimaryItemStack(null);
            this.refreshInventory();
            return;
        }
        if (rawSlot == 5 && this.magicalRecipe.getResult() != null) {
            if (clickType == ClickType.RIGHT) {
                player.getInventory().addItem(new ItemStack[]{this.magicalRecipe.getResult().clone()});
                return;
            }
            if (!isLeft) {
                return;
            }
            this.magicalRecipe.setResult(null);
            this.refreshInventory();
            return;
        }
        if (rawSlot == 7) {
            this.changingViews = true;
            this.guiManager.addPlayerAwait(player.getUniqueId(), this.inventory);
            player.closeInventory();
            player.sendMessage(ConfigSettings.getAwaitInputMainMessage());
            return;
        }
        if (rawSlot < 9) {
            return;
        }
        if (!isLeft && clickType != ClickType.RIGHT) {
            return;
        }
        ItemStack clickedItem = ev.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        clickedItem = clickedItem.clone();
        if (isLeft) {
            this.magicalRecipe.setPrimaryItemStack(new ItemWrapper(clickedItem));
        } else {
            this.magicalRecipe.setResult(clickedItem);
        }
        this.refreshInventory();
    }

    @Override
    public void onClose(InventoryCloseEvent ev) {
        if (this.changingViews) {
            this.changingViews = false;
            return;
        }
        if (ev.getViewers().size() > 1) {
            return;
        }
        this.killInventory();
    }

    @Override
    public void refreshInventory() {
        this.inventory.clear();
        String[] id = new String[]{"{id}", "{waitTime}"};
        String[] replaceId = new String[]{this.magicalRecipe.getId(), ConfigSettings.getWaitTime(this.magicalRecipe.getWaitTime())};
        ItemStack filler = this.guiManager.getItemStackReplaced(ItemIds.FILLER, null, null);
        ItemStack mainIngredient = this.magicalRecipe.getPrimaryItemStack().getItem();
        ItemStack result = this.magicalRecipe.getResult();
        for (int i = 0; i < 9; ++i) {
            this.inventory.setItem(i, filler);
        }
        this.inventory.setItem(1, this.guiManager.getItemStackReplaced(ItemIds.EDIT_INGREDIENTS, id, replaceId));
        this.inventory.setItem(3, mainIngredient != null ? this.guiManager.addMoreLore(mainIngredient, ItemIds.SELECT_MAIN_INGREDIENT, id, replaceId) : this.guiManager.getItemStackReplaced(ItemIds.SELECT_MAIN_INGREDIENT, id, replaceId));
        this.inventory.setItem(5, result != null ? this.guiManager.addMoreLore(result, ItemIds.SELECT_RESULT, id, replaceId) : this.guiManager.getItemStackReplaced(ItemIds.SELECT_RESULT, id, replaceId));
        this.inventory.setItem(7, this.guiManager.getItemStackReplaced(ItemIds.CHANGE_WAIT_TIME, id, replaceId));
    }

    @Override
    public void receiveResponse(Player player, String message) {
        if (player == null || !player.isOnline()) {
            return;
        }
        Integer waitTime = ConfigSettings.convertToSeconds(message);
        if (waitTime == null) {
            player.sendMessage(ConfigSettings.getInvalidInputMainMessage(message));
            this.killInventory();
            return;
        }
        this.magicalRecipe.setWaitTime(waitTime);
        this.refreshInventory();
        player.openInventory(this.inventory);
    }

    @Override
    public Inventory getInventory() {
        return this.inventory;
    }

    public void openParent(Player player) {
        try {
            Bukkit.getScheduler().runTask((Plugin)this.main, () -> player.openInventory(this.inventory));
        }
        catch (Throwable e) {
            this.killInventory();
        }
    }

    @Override
    public void killInventory() {
        this.ingredientsPage.removeParent();
        this.guiManager.removeOpenedGUI(this.id);
        this.guiManager.unregisterGUI(this.ingredientsPage);
        this.guiManager.unregisterGUI(this);
        this.guiManager = null;
        this.magicalRecipe = null;
        this.main = null;
    }
}

