/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Objects.Holders;

import com.deadshotmdf.MagicalCrafting.Utils.MCUtils;
import java.util.Objects;

public class CustomCoords {
    private final int x;
    private final int y;
    private final int z;

    public CustomCoords(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public String toString() {
        return this.x + ";" + this.y + ";" + this.z;
    }

    public static CustomCoords fromString(String str) {
        if (str.isEmpty()) {
            return null;
        }
        String[] split = str.split(";");
        if (split.length != 3) {
            return null;
        }
        Integer x = MCUtils.getInteger(split[0]);
        Integer y = MCUtils.getInteger(split[1]);
        Integer z = MCUtils.getInteger(split[2]);
        if (x == null || y == null || z == null) {
            return null;
        }
        return new CustomCoords(x, y, z);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomCoords)) {
            return false;
        }
        CustomCoords that = (CustomCoords)o;
        return this.x == that.x && this.y == that.y && this.z == that.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }
}

