/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Objects.Misc;

import com.deadshotmdf.MagicalCrafting.Objects.Enums.SkipChecks;
import com.deadshotmdf.MagicalCrafting.Utils.MCUtils;
import com.deadshotmdf.MagicalCrafting.Utils.MCUtilsCompat;
import java.util.EnumSet;
import java.util.Objects;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemWrapper {
    public static final EnumSet<SkipChecks> CHECKS_TO_SKIP;
    private static final boolean IS_NEW_DURABILITY;
    public static boolean METADATA_SKIP_CHECKS;
    private final ItemStack item;

    public ItemWrapper(ItemStack item) {
        this.item = item != null ? item.clone() : null;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public boolean equals(Object o) {
        boolean bothNull;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemWrapper that = (ItemWrapper)o;
        if (CHECKS_TO_SKIP.isEmpty()) {
            return MCUtils.isSameObject(this.item, that.item);
        }
        if (!MCUtils.isValid(this.item, that.item)) {
            return false;
        }
        if (CHECKS_TO_SKIP.contains((Object)SkipChecks.ALL)) {
            return this.item.getType() == that.item.getType();
        }
        if (!CHECKS_TO_SKIP.contains((Object)SkipChecks.AMOUNT) && !MCUtils.isSameAmount(this.item, that.item)) {
            return false;
        }
        if (!(CHECKS_TO_SKIP.contains((Object)SkipChecks.DURABILITY) || IS_NEW_DURABILITY || MCUtils.isSameOldDurability(this.item, that.item))) {
            return false;
        }
        ItemMeta meta1 = this.item.getItemMeta();
        ItemMeta meta2 = that.item.getItemMeta();
        boolean validMetadata = MCUtils.isValid(meta1, meta2);
        boolean bl = bothNull = meta1 == null && meta2 == null;
        if (CHECKS_TO_SKIP.contains((Object)SkipChecks.ITEM_META)) {
            return true;
        }
        if (!(CHECKS_TO_SKIP.contains((Object)SkipChecks.ITEM_META) || METADATA_SKIP_CHECKS || validMetadata && !bothNull && meta1.equals(meta2))) {
            return false;
        }
        if (!CHECKS_TO_SKIP.contains((Object)SkipChecks.DURABILITY) && IS_NEW_DURABILITY && !MCUtilsCompat.isSameDurability(this.item, that.item)) {
            return false;
        }
        if (!(CHECKS_TO_SKIP.contains((Object)SkipChecks.NAME) || validMetadata && !bothNull && MCUtils.isSameObject(meta1.getDisplayName(), meta2.getDisplayName()))) {
            return false;
        }
        if (!(CHECKS_TO_SKIP.contains((Object)SkipChecks.LORE) || validMetadata && !bothNull && MCUtils.isSameObject(meta1.getLore(), meta2.getLore()))) {
            return false;
        }
        if (!(CHECKS_TO_SKIP.contains((Object)SkipChecks.CUSTOM_MODEL_DATA) || validMetadata && !bothNull && MCUtilsCompat.isSameCustomModelData(meta1, meta2))) {
            return false;
        }
        if (!(CHECKS_TO_SKIP.contains((Object)SkipChecks.ENCHANTS) || validMetadata && !bothNull && MCUtils.isSameObject(meta1.getEnchants(), meta2.getEnchants()))) {
            return false;
        }
        if (!(CHECKS_TO_SKIP.contains((Object)SkipChecks.ITEM_FLAGS) || validMetadata && !bothNull && MCUtils.isSameObject(meta1.getItemFlags(), meta2.getItemFlags()))) {
            return false;
        }
        return CHECKS_TO_SKIP.contains((Object)SkipChecks.ALL_CUSTOM_NBT_TAGS) || validMetadata && !bothNull && MCUtilsCompat.areSameTags(meta1, meta2);
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + Objects.hash(this.item.getType()) + (!IS_NEW_DURABILITY ? (int)this.item.getData().getData() : 0);
        if (CHECKS_TO_SKIP.contains((Object)SkipChecks.ALL)) {
            return result;
        }
        if (!CHECKS_TO_SKIP.contains((Object)SkipChecks.AMOUNT)) {
            result = 31 * result + this.item.getAmount();
        }
        if (!CHECKS_TO_SKIP.contains((Object)SkipChecks.DURABILITY) && !IS_NEW_DURABILITY) {
            result = 31 * result + this.item.getDurability();
        }
        ItemMeta meta = this.item.getItemMeta();
        if (CHECKS_TO_SKIP.contains((Object)SkipChecks.ITEM_META) || meta == null) {
            return result;
        }
        if (!CHECKS_TO_SKIP.contains((Object)SkipChecks.ITEM_META) && !METADATA_SKIP_CHECKS) {
            return 31 * result + meta.hashCode();
        }
        if (!CHECKS_TO_SKIP.contains((Object)SkipChecks.DURABILITY) && IS_NEW_DURABILITY) {
            result = 31 * result + MCUtilsCompat.hashDurability(this.item);
        }
        if (!CHECKS_TO_SKIP.contains((Object)SkipChecks.NAME)) {
            result = 31 * result + Objects.hashCode(meta.getDisplayName());
        }
        if (!CHECKS_TO_SKIP.contains((Object)SkipChecks.LORE)) {
            result = 31 * result + Objects.hashCode(meta.getLore());
        }
        if (!CHECKS_TO_SKIP.contains((Object)SkipChecks.CUSTOM_MODEL_DATA)) {
            result = 31 * result + MCUtilsCompat.hashCustomModelData(meta);
        }
        if (!CHECKS_TO_SKIP.contains((Object)SkipChecks.ENCHANTS)) {
            result = 31 * result + Objects.hashCode(meta.getEnchants());
        }
        if (!CHECKS_TO_SKIP.contains((Object)SkipChecks.ITEM_FLAGS)) {
            result = 31 * result + Objects.hashCode(meta.getItemFlags());
        }
        if (!CHECKS_TO_SKIP.contains((Object)SkipChecks.ALL_CUSTOM_NBT_TAGS)) {
            result = 31 * result + MCUtilsCompat.hashTags(meta);
        }
        return result;
    }

    static {
        boolean b;
        CHECKS_TO_SKIP = EnumSet.noneOf(SkipChecks.class);
        try {
            Class.forName("org.bukkit.inventory.meta.Damageable");
            b = true;
        }
        catch (Throwable e) {
            b = false;
        }
        IS_NEW_DURABILITY = b;
    }
}

