/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Objects.Misc;

import com.deadshotmdf.MagicalCrafting.ConfigSettings;
import com.deadshotmdf.MagicalCrafting.MC;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.ActiveStructure;
import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class StructureTimer
implements Runnable {
    private MC main;
    private ActiveStructure activeStructure;
    private boolean doingRecipe;
    private int waitTime;
    private Hologram hologram;

    public StructureTimer(MC main, ActiveStructure activeStructure, Hologram hologram) {
        this.main = main;
        this.activeStructure = activeStructure;
        this.hologram = hologram;
    }

    @Override
    public void run() {
        if (this.doingRecipe) {
            this.updateHologram();
        }
        if (!this.doingRecipe || this.waitTime-- > 0) {
            return;
        }
        this.doingRecipe = false;
        Bukkit.getScheduler().runTask((Plugin)this.main, this::finishRecipe);
    }

    public void stopRecipe() {
        this.doingRecipe = false;
        this.waitTime = 0;
        this.activeStructure.setCurrentRecipe(null);
        DHAPI.removeHologramLine((Hologram)this.hologram, (int)0);
    }

    public void setNewRecipe(int waitTime) {
        this.doingRecipe = true;
        this.waitTime = waitTime;
        this.updateHologram();
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void onEnd() {
        this.hologram.destroy();
        this.hologram = null;
        this.main = null;
        this.activeStructure = null;
    }

    private void finishRecipe() {
        this.activeStructure.finishRecipe();
        this.stopRecipe();
    }

    private void updateHologram() {
        try {
            DHAPI.setHologramLine((Hologram)this.hologram, (int)0, (String)ConfigSettings.getWaitTime(this.waitTime));
        }
        catch (Throwable e) {
            DHAPI.addHologramLine((Hologram)this.hologram, (String)"");
        }
    }
}

