/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Objects.Saveable;

import com.deadshotmdf.MagicalCrafting.ConfigSettings;
import com.deadshotmdf.MagicalCrafting.MC;
import com.deadshotmdf.MagicalCrafting.Managers.RecipesManager;
import com.deadshotmdf.MagicalCrafting.Managers.StructureSettingsManager;
import com.deadshotmdf.MagicalCrafting.Objects.Misc.ItemWrapper;
import com.deadshotmdf.MagicalCrafting.Objects.Misc.StructureTimer;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.InformationHolder;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.MagicalRecipe;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.StructureSettings;
import com.deadshotmdf.MagicalCrafting.Utils.MCUtils;
import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ActiveStructure
extends InformationHolder {
    private String baseId = null;
    private UUID owner;
    private UUID world;
    private Set<Location> blocks;
    private HashMap<Location, ItemWrapper> pedestals;
    private HashMap<Location, Hologram> entities;
    private Location core;
    private ItemWrapper coreItem;
    private MagicalRecipe currentRecipe;
    private StructureTimer structureTimer;
    private int taskId;
    private int tempWaitTime;

    public ActiveStructure(MC main, String id, Object recipesManager) {
        super(main, "builds/" + id + ".yml", id, recipesManager);
        this.loadInformation();
        this.init(main, this.baseId, this.owner, this.blocks, this.pedestals, this.core, this.coreItem, this.currentRecipe, this.tempWaitTime);
    }

    public ActiveStructure(MC main, String baseId, String id, UUID owner, Set<Location> blocks, HashMap<Location, ItemWrapper> pedestals, Location core) {
        super(main, "builds/" + id + ".yml", id, null);
        this.init(main, baseId, owner, blocks, pedestals, core, new ItemWrapper(null), null, 0);
    }

    private void init(MC main, String baseId, UUID owner, Set<Location> blocks, HashMap<Location, ItemWrapper> pedestals, Location core, ItemWrapper coreItem, MagicalRecipe currentRecipe, int waitTime) {
        this.baseId = baseId;
        this.owner = owner;
        this.blocks = blocks;
        this.pedestals = pedestals;
        this.entities = new HashMap();
        this.core = core;
        this.coreItem = coreItem;
        this.world = core.getWorld().getUID();
        this.pedestals.forEach(this::spawnHologram);
        this.spawnHologram(this.core, this.coreItem, true);
        this.structureTimer = new StructureTimer(main, this, DHAPI.createHologram((String)(this.getId() + "-00-" + core).replaceAll("[^a-zA-Z0-9-_]", ""), (Location)core.clone().add(0.5, 2.0, 0.5)));
        this.taskId = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)main, (Runnable)this.structureTimer, 20L, 20L).getTaskId();
        this.currentRecipe = currentRecipe;
        if (currentRecipe != null) {
            this.structureTimer.setNewRecipe(waitTime);
        }
        FixedMetadataValue val = new FixedMetadataValue((Plugin)main, (Object)this.id);
        FixedMetadataValue val2 = new FixedMetadataValue((Plugin)main, (Object)true);
        blocks.forEach(block -> block.getBlock().setMetadata("magic_craft-in.bl0ck-_iden_-", (MetadataValue)val));
        this.pedestals.keySet().forEach(block -> block.getBlock().setMetadata("pedestal_metadata_mag-MC.ic_-craft", (MetadataValue)val2));
        core.getBlock().setMetadata("core_metad.MC-ata_magic_-craft", (MetadataValue)val2);
    }

    public void setCurrentRecipe(MagicalRecipe recipe) {
        this.currentRecipe = recipe;
    }

    public MagicalRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void stopRecipe() {
        this.structureTimer.stopRecipe();
    }

    public void onInteract(Player player, Location location, ItemStack item, RecipesManager recipesManager, StructureSettingsManager structureSettingsManager) {
        UUID other = player.getUniqueId();
        if (ConfigSettings.getOnlyOwnerCanInteract() && !other.equals(this.owner) && !player.hasPermission("magicalcrafting.ownerbypass")) {
            return;
        }
        if (!((StructureSettings)structureSettingsManager.getValueByIdOrNew(this.owner.toString())).canAccess(this.owner, other, player.hasPermission("magicalcrafting.ownerbypass"))) {
            return;
        }
        boolean isCore = location.equals((Object)this.core);
        if (!isCore && !this.pedestals.containsKey(location)) {
            return;
        }
        ItemStack existing = isCore ? this.coreItem.getItem() : this.pedestals.get(location).getItem();
        this.stopRecipe();
        if (existing == null) {
            if (item == null || item.getType().toString().endsWith("AIR")) {
                return;
            }
            if (!this.spawnHologram(location, new ItemWrapper(item.clone()), isCore)) {
                return;
            }
            player.getInventory().removeItem(new ItemStack[]{item});
            this.startRecipe(recipesManager);
            return;
        }
        player.getInventory().addItem(new ItemStack[]{existing});
        Hologram hologram = this.entities.get(location);
        if (hologram != null) {
            DHAPI.removeHologramLine((Hologram)hologram, (int)0);
        }
        if (isCore) {
            this.coreItem = new ItemWrapper(null);
        } else {
            this.pedestals.put(location, new ItemWrapper(null));
        }
        this.startRecipe(recipesManager);
    }

    public void destroyStructure(MC main) {
        Bukkit.getScheduler().cancelTask(this.taskId);
        for (Location loc : this.blocks) {
            Block block = loc.getBlock();
            block.removeMetadata("magic_craft-in.bl0ck-_iden_-", (Plugin)main);
            block.removeMetadata("core_metad.MC-ata_magic_-craft", (Plugin)main);
            block.removeMetadata("pedestal_metadata_mag-MC.ic_-craft", (Plugin)main);
        }
        this.entities.values().forEach(Hologram::destroy);
        World world = this.blocks.iterator().next().getWorld();
        this.pedestals.put(this.core, new ItemWrapper(this.coreItem.getItem()));
        this.pedestals.forEach((k, v) -> {
            if (v != null && v.getItem() != null) {
                world.dropItemNaturally(k.clone().add(0.5, 0.6, 0.5), v.getItem());
            }
        });
        this.structureTimer.onEnd();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)main, () -> new File(main.getDataFolder(), "builds/" + this.getId() + ".yml").delete());
    }

    public void finishRecipe() {
        if (this.currentRecipe == null) {
            return;
        }
        this.entities.values().forEach(hologram -> DHAPI.removeHologramLine((Hologram)hologram, (int)0));
        this.coreItem = new ItemWrapper(this.currentRecipe.getResult().clone());
        this.spawnHologram(this.core, this.coreItem);
        this.currentRecipe = null;
        this.pedestals.replaceAll((k, v) -> new ItemWrapper(null));
    }

    private void spawnHologram(Location location, ItemWrapper item) {
        this.spawnHologram(location, item, false);
    }

    private boolean spawnHologram(Location location, ItemWrapper stack, boolean isCore) {
        if (location == null) {
            return false;
        }
        Hologram hologram = this.entities.computeIfAbsent(location, k -> DHAPI.createHologram((String)(this.getId() + "-" + location).replaceAll("[^a-zA-Z0-9-_]", ""), (Location)location.clone().add(0.5, 1.5, 0.5)));
        ItemStack item = this.pedestals.getOrDefault(location, new ItemWrapper(null)).getItem();
        DHAPI.removeHologramLine((Hologram)hologram, (int)0);
        if (item == null) {
            item = stack != null && stack.getItem() != null ? stack.getItem() : (isCore ? this.coreItem.getItem() : this.pedestals.get(location).getItem());
        }
        if (item == null) {
            return false;
        }
        if (isCore) {
            this.coreItem = new ItemWrapper(item);
        } else {
            this.pedestals.put(location, new ItemWrapper(item));
        }
        DHAPI.addHologramLine((Hologram)hologram, (ItemStack)item);
        return true;
    }

    private void startRecipe(RecipesManager recipesManager) {
        this.currentRecipe = recipesManager.getRecipeByItems(this.baseId, this.coreItem, this.pedestals.values());
        if (this.currentRecipe != null) {
            this.structureTimer.setNewRecipe(this.currentRecipe.getWaitTime());
        }
    }

    @Override
    public void loadInformation() {
        this.baseId = this.config.getString("baseId");
        this.owner = MCUtils.getUUID(this.config.getString("owner"));
        if (this.owner == null) {
            throw new NullPointerException("Owner cannot be null");
        }
        this.currentRecipe = (MagicalRecipe)((RecipesManager)this.o).getValueById(this.config.getString("currentRecipe"));
        this.tempWaitTime = this.config.getInt("waitTime");
        this.blocks = new HashSet<Location>();
        for (String locString : this.config.getStringList("blocks")) {
            this.blocks.add(MCUtils.locationFromString(locString));
        }
        this.pedestals = new HashMap();
        this.core = MCUtils.locationFromString(this.config.getString("core"));
        this.coreItem = new ItemWrapper(this.config.getItemStack("coreItem"));
        this.o = null;
        Set<String> keys = this.getKeys("pedestals", false);
        if (keys.isEmpty()) {
            return;
        }
        for (String key : keys) {
            Location loc = MCUtils.locationFromString(this.config.getString("pedestals." + key + ".location"));
            if (loc == null) continue;
            this.pedestals.put(loc, new ItemWrapper(this.config.getItemStack("pedestals." + key + ".item")));
        }
    }

    @Override
    public void saveInformation() {
        this.config.set("baseId", (Object)this.baseId);
        this.config.set("id", (Object)this.id);
        this.config.set("owner", (Object)this.owner.toString());
        this.config.set("coreItem", (Object)this.coreItem.getItem());
        this.config.set("currentRecipe", this.currentRecipe != null ? this.currentRecipe.getId() : null);
        this.config.set("waitTime", (Object)this.structureTimer.getWaitTime());
        ArrayList<String> blockStrings = new ArrayList<String>();
        for (Location loc : this.blocks) {
            blockStrings.add(MCUtils.locationToString(this.world, loc));
        }
        this.config.set("blocks", blockStrings);
        int i = 0;
        for (Map.Entry<Location, ItemWrapper> entry : this.pedestals.entrySet()) {
            this.config.set("pedestals." + i + ".location", (Object)MCUtils.locationToString(this.world, entry.getKey()));
            this.config.set("pedestals." + i++ + ".item", (Object)entry.getValue().getItem());
        }
        this.config.set("core", (Object)MCUtils.locationToString(this.world, this.core));
        this.entities.values().forEach(Hologram::destroy);
        this.structureTimer.onEnd();
        this.saveC();
    }
}

