/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Objects.Saveable;

import com.deadshotmdf.MagicalCrafting.MC;
import com.deadshotmdf.MagicalCrafting.Managers.RecipesManager;
import com.deadshotmdf.MagicalCrafting.Objects.Holders.BlockDataHolder;
import com.deadshotmdf.MagicalCrafting.Objects.Holders.CustomCoords;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.InformationHolder;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.MagicalRecipe;
import com.deadshotmdf.MagicalCrafting.Utils.MCUtils;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.material.MaterialData;

public class CraftStructure
extends InformationHolder {
    private final HashMap<CustomCoords, BlockDataHolder> structure = new HashMap();
    private final EnumSet<Material> materials = EnumSet.noneOf(Material.class);
    private final Set<CustomCoords> pedestals = new HashSet<CustomCoords>();
    private final Set<MagicalRecipe> recipes = new HashSet<MagicalRecipe>();
    private CustomCoords core;
    private int width;
    private int height;
    private int depth;

    public CraftStructure(MC main, String id, Object o) {
        super(main, "structures/" + id + ".yml", id, o);
        this.loadInformation();
    }

    public Set<MagicalRecipe> getRecipes() {
        return this.recipes;
    }

    public CustomCoords getCore() {
        return this.core;
    }

    public int pedestalSize() {
        return this.pedestals.size();
    }

    public boolean isPedestal(CustomCoords coords) {
        return this.pedestals.contains(coords);
    }

    public boolean containsMaterial(Material material) {
        return this.materials.contains(material);
    }

    public Set<Material> getMaterialsClone() {
        return this.materials.clone();
    }

    public BlockDataHolder getBlockDataAtCoords(CustomCoords coords) {
        return this.structure.get(coords);
    }

    public Set<CustomCoords> getAllOffsets() {
        return this.structure.keySet();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public void addBlock(CustomCoords coords, BlockDataHolder data, boolean isCore, boolean isPedestal) {
        this.structure.put(coords, data);
        if (isCore) {
            this.core = coords;
        } else if (isPedestal) {
            this.pedestals.add(coords);
        }
        Material newMaterial = data.getBlockDataMaterial();
        this.materials.add(newMaterial == null ? data.getMaterialDataOld().getItemType() : newMaterial);
        this.calculateValues();
    }

    @Override
    public void saveInformation() {
        for (Map.Entry<CustomCoords, BlockDataHolder> entry : this.structure.entrySet()) {
            CustomCoords key = entry.getKey();
            BlockDataHolder data = entry.getValue();
            String path = "data." + key.toString();
            this.config.set(path + ".isCore", (Object)key.equals(this.core));
            this.config.set(path + ".isPedestals", (Object)this.pedestals.contains(key));
            this.config.set(path + ".blockData", (Object)data.getBlockDataString());
            this.config.set(path + ".blockDataMaterial", (Object)data.getBlockDataMaterial());
            this.config.set(path + ".blockDataOldMaterial", (Object)data.getMaterialDataOld().getItemType().toString());
            this.config.set(path + ".blockDataOldData", (Object)data.getMaterialDataOld().getData());
        }
        LinkedList<String> recipesList = new LinkedList<String>();
        for (MagicalRecipe recipe : this.recipes) {
            recipesList.add(recipe.getId().toLowerCase());
        }
        this.config.set("recipes", recipesList);
        this.saveC();
    }

    @Override
    public void loadInformation() {
        Set<String> keys = this.getKeys("data", false);
        if (keys.isEmpty()) {
            return;
        }
        for (String key : keys) {
            CustomCoords coords = CustomCoords.fromString(key);
            if (coords == null) continue;
            String path = "data." + key;
            BlockDataHolder blockDataHolder = new BlockDataHolder(this.config.getString(path + ".blockData"), this.config.getString(path + ".blockDataMaterial"), new MaterialData(MCUtils.getMaterial(this.config.getString(path + ".blockDataOldMaterial")), (byte)this.config.getInt(path + ".blockDataOldData")));
            if (this.config.getBoolean(path + ".isCore")) {
                this.core = coords;
            }
            if (this.config.getBoolean(path + ".isPedestals")) {
                this.pedestals.add(coords);
            }
            this.structure.put(coords, blockDataHolder);
            Material newMaterial = blockDataHolder.getBlockDataMaterial();
            this.materials.add(newMaterial == null ? blockDataHolder.getMaterialDataOld().getItemType() : newMaterial);
            this.calculateValues();
        }
        List list = this.config.getStringList("recipes");
        RecipesManager recipesManager = (RecipesManager)this.o;
        for (String recipeString : list) {
            MagicalRecipe recipe = (MagicalRecipe)recipesManager.getValueById(recipeString);
            if (recipe == null) continue;
            this.recipes.add(recipe);
        }
        this.o = null;
    }

    private void calculateValues() {
        Set<CustomCoords> set = this.structure.keySet();
        this.width = CraftStructure.getValue(set, 0);
        this.height = CraftStructure.getValue(set, 1);
        this.depth = CraftStructure.getValue(set, 2);
    }

    private static int getValue(Set<CustomCoords> set, int mode) {
        int minValue = Integer.MAX_VALUE;
        int maxValue = Integer.MIN_VALUE;
        for (CustomCoords coords : set) {
            minValue = Math.min(minValue, mode == 0 ? coords.getX() : (mode == 1 ? coords.getY() : coords.getZ()));
            maxValue = Math.max(maxValue, mode == 0 ? coords.getX() : (mode == 1 ? coords.getY() : coords.getZ()));
        }
        return maxValue - minValue + 1;
    }
}

