/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Objects.Saveable;

import com.deadshotmdf.MagicalCrafting.MC;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class InformationHolder {
    protected final File file;
    protected final String id;
    protected final FileConfiguration config;
    protected Object o;
    private static final Set<String> KEYS = Collections.unmodifiableSet(new HashSet());

    public InformationHolder(MC main, String name, String id, Object o) {
        if (main == null || name == null || id == null) {
            throw new NullPointerException("Cannot have null value for plugin, name, or id");
        }
        this.file = new File(main.getDataFolder(), name.toLowerCase());
        this.id = id.toLowerCase();
        this.o = o;
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public String getId() {
        return this.id;
    }

    public void saveInformation() {
    }

    public void loadInformation() {
    }

    public Set<String> getKeys(String path, boolean deep) {
        ConfigurationSection sec = this.config.getConfigurationSection(path);
        if (sec == null) {
            return KEYS;
        }
        return sec.getKeys(deep);
    }

    public void saveC() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadC() {
        try {
            this.config.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

