/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Objects.Saveable;

import com.deadshotmdf.MagicalCrafting.MC;
import com.deadshotmdf.MagicalCrafting.Objects.Misc.ItemWrapper;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.InformationHolder;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.bukkit.inventory.ItemStack;

public class MagicalRecipe
extends InformationHolder {
    private int waitTime;
    private HashSet<ItemWrapper> ingredients;
    private ItemWrapper primaryItemStack;
    private ItemStack result;

    public MagicalRecipe(MC main, String id, Object o) {
        super(main, "recipes/" + id + ".yml", id, o);
        this.loadInformation();
        this.waitTime = Math.max(1, this.waitTime);
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public HashSet<ItemWrapper> getIngredients() {
        return this.ingredients;
    }

    public ItemWrapper getPrimaryItemStack() {
        return this.primaryItemStack;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public void setPrimaryItemStack(ItemWrapper primaryItemStack) {
        this.primaryItemStack = primaryItemStack;
    }

    public void setResult(ItemStack result) {
        this.result = result;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = Math.max(1, waitTime);
    }

    public void onReload() {
        this.ingredients = new HashSet<ItemWrapper>(this.ingredients);
    }

    @Override
    public void loadInformation() {
        this.waitTime = this.config.getInt("waitTime");
        this.ingredients = new HashSet();
        this.primaryItemStack = new ItemWrapper(this.config.getItemStack("primaryItemStack"));
        this.result = this.config.getItemStack("result");
        Set<String> keys = this.getKeys("ingredients", false);
        if (keys.isEmpty()) {
            return;
        }
        for (String key : keys) {
            ItemStack item = this.config.getItemStack("ingredients." + key);
            if (item == null) continue;
            this.ingredients.add(new ItemWrapper(item));
        }
    }

    @Override
    public void saveInformation() {
        this.config.set("waitTime", (Object)this.waitTime);
        this.config.set("primaryItemStack", (Object)this.primaryItemStack.getItem());
        this.config.set("result", (Object)this.result);
        this.config.set("ingredients", null);
        int i = 0;
        for (ItemWrapper ingredient : this.ingredients) {
            if (ingredient == null) continue;
            this.config.set("ingredients." + i++, (Object)ingredient.getItem());
        }
        this.saveC();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MagicalRecipe)) {
            return false;
        }
        MagicalRecipe recipe = (MagicalRecipe)o;
        return this.waitTime == recipe.waitTime && Objects.equals(this.ingredients, recipe.ingredients) && Objects.equals(this.primaryItemStack, recipe.primaryItemStack) && Objects.equals(this.result, recipe.result);
    }

    public int hashCode() {
        return Objects.hash(this.waitTime, this.ingredients, this.primaryItemStack, this.result);
    }
}

