/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Objects.Saveable;

import com.deadshotmdf.MagicalCrafting.MC;
import com.deadshotmdf.MagicalCrafting.Objects.Misc.TriFunction;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.InformationHolder;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;

public abstract class MultiInformationHolder<T extends InformationHolder> {
    protected final MC main;
    private final String folder;
    private final Object extra;
    private final HashMap<String, T> values;
    private final TriFunction<MC, String, Object, T> constructor;

    public MultiInformationHolder(MC main, String folder, Object extra, TriFunction<MC, String, Object, T> constructor) {
        this.main = main;
        this.folder = folder;
        this.extra = extra;
        this.values = new HashMap();
        this.constructor = constructor;
        this.loadAll();
    }

    public void loadAll() {
        this.values.clear();
        File structuresDir = new File(this.main.getDataFolder(), this.folder);
        if (!structuresDir.exists() || !structuresDir.isDirectory()) {
            structuresDir.mkdirs();
        }
        for (File file : Objects.requireNonNull(structuresDir.listFiles())) {
            if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
            String id = file.getName().replace(".yml", "").toLowerCase();
            try {
                this.values.put(id, this.constructor.apply(this.main, id, this.extra));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void saveAll() {
        this.values.values().forEach(InformationHolder::saveInformation);
    }

    public T remove(String id) {
        return (T)((InformationHolder)this.values.remove(id != null ? id.toLowerCase() : "NULL"));
    }

    public boolean containsKey(String id) {
        return this.values.containsKey(id != null ? id.toLowerCase() : "NULL");
    }

    public void put(String id, T value) {
        if (id == null) {
            return;
        }
        this.values.put(id.toLowerCase(), value);
    }

    public T getValueById(String id) {
        return (T)((InformationHolder)this.values.get(id != null ? id.toLowerCase() : "NULL"));
    }

    public T getValueByIdOrNew(String id) {
        return (T)(id != null ? this.values.computeIfAbsent(id.toLowerCase(), key -> (InformationHolder)this.constructor.apply(this.main, (String)key, this.extra)) : null);
    }

    public Collection<T> getValues() {
        return this.values.values();
    }
}

