/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Objects.Saveable;

import com.deadshotmdf.MagicalCrafting.MC;
import com.deadshotmdf.MagicalCrafting.Objects.Enums.AltarAccessStatus;
import com.deadshotmdf.MagicalCrafting.Objects.Saveable.InformationHolder;
import com.deadshotmdf.MagicalCrafting.Utils.MCUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class StructureSettings
extends InformationHolder {
    private final Set<UUID> friends = new HashSet<UUID>();
    private AltarAccessStatus accessStatus;
    private AltarAccessStatus oldAccessStatus;

    public StructureSettings(MC main, String id, Object o) {
        super(main, "structuresettings/" + id + ".yml", id, o);
        this.loadInformation();
    }

    public boolean modifyFriend(UUID uuid, boolean add) {
        return add ? this.friends.add(uuid) : this.friends.remove(uuid);
    }

    public boolean isFriend(UUID uuid) {
        return this.friends.contains(uuid);
    }

    public Set<UUID> getFriendsClone() {
        return new HashSet<UUID>(this.friends);
    }

    public AltarAccessStatus getAccessStatus() {
        return this.accessStatus;
    }

    public void setBackToOldStatus() {
        if (this.oldAccessStatus == AltarAccessStatus.PRIVATE) {
            return;
        }
        this.accessStatus = this.oldAccessStatus;
        this.oldAccessStatus = AltarAccessStatus.PRIVATE;
    }

    public AltarAccessStatus setNextAlterStatus() {
        this.accessStatus = this.accessStatus.getNext();
        return this.accessStatus;
    }

    public AltarAccessStatus getNextAlterStatus() {
        return this.accessStatus.getNext();
    }

    public void setAccessStatus(AltarAccessStatus accessStatus, boolean saveOld) {
        if (accessStatus == null) {
            throw new NullPointerException("accessStatus cannot be null");
        }
        if (saveOld) {
            this.oldAccessStatus = this.accessStatus;
        }
        this.accessStatus = accessStatus;
    }

    public boolean canAccess(UUID owner, UUID other, boolean isBypass) {
        if (this.accessStatus == AltarAccessStatus.PRIVATE && !owner.equals(other) && !isBypass) {
            return false;
        }
        return isBypass || this.accessStatus != AltarAccessStatus.FRIENDS_ONLY || this.friends.contains(other);
    }

    @Override
    public void loadInformation() {
        this.accessStatus = AltarAccessStatus.fromString(this.config.getString("accessStatus"));
        this.oldAccessStatus = AltarAccessStatus.fromString(this.config.getString("oldAccessStatus"));
        List possibleFriends = this.config.getStringList("friends");
        if (possibleFriends.isEmpty()) {
            return;
        }
        for (String friend : possibleFriends) {
            UUID uuid = MCUtils.getUUID(friend);
            if (uuid == null) continue;
            this.friends.add(uuid);
        }
    }

    @Override
    public void saveInformation() {
        this.config.set("accessStatus", (Object)this.accessStatus.toString());
        this.config.set("oldAccessStatus", (Object)this.oldAccessStatus.toString());
        LinkedList<String> possibleFriends = new LinkedList<String>();
        for (UUID uuid : this.friends) {
            possibleFriends.add(uuid.toString());
        }
        this.config.set("friends", possibleFriends);
        this.saveC();
    }
}

