/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Utils;

import com.deadshotmdf.MagicalCrafting.ConfigSettings;
import com.deadshotmdf.MagicalCrafting.Utils.MCUtilsCompat;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.MetadataValue;

public class MCUtils {
    public static final boolean IS_NEW;

    public static Integer getInteger(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Material getMaterial(String s) {
        try {
            return Material.valueOf((String)s.toUpperCase());
        }
        catch (Throwable e) {
            return Material.DIRT;
        }
    }

    public static Material getMaterialOrNull(String s) {
        try {
            return Material.valueOf((String)s.toUpperCase());
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static UUID getUUID(String s) {
        try {
            return UUID.fromString(s);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static UUID getUUID(List<MetadataValue> metadataValues) {
        try {
            return UUID.fromString(metadataValues.get(0).asString());
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static boolean isMainHand(PlayerInteractEvent ev) {
        try {
            return ev.getHand() == EquipmentSlot.HAND;
        }
        catch (Throwable e) {
            return true;
        }
    }

    public static String locationToString(UUID world, Location loc) {
        return world + ";" + loc.getBlockX() + ";" + loc.getBlockY() + ";" + loc.getBlockZ();
    }

    public static Location locationFromString(String s) {
        if (s == null) {
            return null;
        }
        String[] split = s.split(";");
        if (split.length != 4) {
            return null;
        }
        UUID worldUUID = MCUtils.getUUID(split[0]);
        if (worldUUID == null) {
            return null;
        }
        World world = Bukkit.getWorld((UUID)worldUUID);
        if (world == null) {
            return null;
        }
        Integer x = MCUtils.getInteger(split[1]);
        Integer y = MCUtils.getInteger(split[2]);
        Integer z = MCUtils.getInteger(split[3]);
        if (x == null || y == null || z == null) {
            return null;
        }
        return new Location(world, (double)x.intValue(), (double)y.intValue(), (double)z.intValue());
    }

    public static ItemStack createItem(String name, List<String> lore, int amount, short data, Material material, boolean glow, int customModelData) {
        ItemMeta meta;
        ItemStack item = new ItemStack(material, amount, data);
        if (glow) {
            item.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
        }
        if ((meta = item.getItemMeta()) == null) {
            return item;
        }
        if (name != null) {
            meta.setDisplayName(ConfigSettings.color(name));
        }
        if (lore != null && !lore.isEmpty()) {
            meta.setLore(ConfigSettings.color(lore));
        }
        if (glow) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        MCUtilsCompat.setCustomModelData(meta, customModelData);
        item.setItemMeta(meta);
        return item;
    }

    public static boolean isValid(Object meta1, Object meta2) {
        return meta1 == null && meta2 == null || meta1 != null && meta2 != null;
    }

    public static boolean isSameObject(Object obj1, Object obj2) {
        return obj1 == null && obj2 == null || obj1 != null && obj1.equals(obj2);
    }

    public static boolean isSameOldDurability(ItemStack item1, ItemStack itm2) {
        return item1 == null && itm2 == null || item1 != null && itm2 != null && item1.getDurability() == itm2.getDurability();
    }

    public static boolean isSameAmount(ItemStack item1, ItemStack itm2) {
        return item1 == null && itm2 == null || item1 != null && itm2 != null && item1.getAmount() == itm2.getAmount();
    }

    static {
        boolean result = false;
        try {
            Class.forName("org.bukkit.block.data.BlockData");
            result = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IS_NEW = result;
    }
}

