/*
 * Decompiled with CFR 0.152.
 */
package com.deadshotmdf.MagicalCrafting.Utils;

import com.deadshotmdf.MagicalCrafting.Objects.Holders.BlockDataHolder;
import com.deadshotmdf.MagicalCrafting.Utils.MCUtils;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class MCUtilsCompat {
    public static Object[] getBlockData(Block block) {
        try {
            BlockData data = block.getBlockData();
            return new Object[]{data.getAsString(), data.getMaterial()};
        }
        catch (Throwable e) {
            return new Object[]{null, null};
        }
    }

    public static boolean isSame(Block block, BlockDataHolder expectedData) {
        try {
            return block.getBlockData().getAsString().equals(expectedData.getBlockDataString());
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void setCustomModelData(ItemMeta meta, int customModelData) {
        try {
            meta.setCustomModelData(Integer.valueOf(customModelData));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean isSameCustomModelData(ItemMeta meta1, ItemMeta meta2) {
        try {
            return meta1.getCustomModelData() == meta2.getCustomModelData();
        }
        catch (Throwable ignored) {
            return true;
        }
    }

    public static boolean areSameTags(ItemMeta meta1, ItemMeta meta2) {
        try {
            return meta1.getPersistentDataContainer().equals(meta2.getPersistentDataContainer());
        }
        catch (Throwable ignored) {
            try {
                return meta1.getCustomTagContainer().equals(meta2.getCustomTagContainer());
            }
            catch (Throwable ignored2) {
                return true;
            }
        }
    }

    public static boolean isSameDurability(ItemStack item1, ItemStack itm2) {
        try {
            ItemMeta meta1 = item1.getItemMeta();
            ItemMeta meta2 = itm2.getItemMeta();
            boolean is1 = meta1 instanceof Damageable;
            boolean is2 = meta2 instanceof Damageable;
            if (is1 && is2) {
                return ((Damageable)meta1).getDamage() == ((Damageable)meta2).getDamage();
            }
            return !is1 && !is2;
        }
        catch (Throwable ignored) {
            return MCUtils.isSameOldDurability(item1, itm2);
        }
    }

    public static int hashDurability(ItemStack item) {
        try {
            return item.getItemMeta() instanceof Damageable ? Integer.hashCode(item.getDurability()) : 0;
        }
        catch (Throwable ignored) {
            return item != null ? Integer.hashCode(item.getDurability()) : 0;
        }
    }

    public static int hashCustomModelData(ItemMeta meta) {
        try {
            return meta != null && meta.hasCustomModelData() ? Integer.hashCode(meta.getCustomModelData()) : 0;
        }
        catch (Throwable ignored) {
            return 0;
        }
    }

    public static int hashTags(ItemMeta meta) {
        if (meta == null) {
            return 0;
        }
        try {
            return meta.getPersistentDataContainer().hashCode();
        }
        catch (Throwable ignored) {
            return 0;
        }
    }
}

