# Evol's 3D Amethyst Resource Pack

Welcome to **Evol's 3D Amethyst**, a resource pack designed to transform your Minecraft amethyst experience! This pack replaces the default flat amethyst panels with stunning, fully 3D models and introduces updated textures. Dive deeper into the geode with new block variants for existing amethyst blocks and enjoy full PBR (Physically Based Rendering) support, alongside emissive support for that extra glow, compatible with OptiFine or similar Fabric-based support mods.

## Features

- **Fully 3D Amethyst Panels:** No more flat panels! Each amethyst panel is now a beautifully rendered 3D model, adding depth and realism to your builds and amethyst geode discoveries.

- **Enhanced Textures:** Enjoy meticulously updated textures that complement the new 3D models, bringing a vibrant and polished look to all amethyst-related blocks.

- **New Amethyst Block Variants:** Discover exciting new visual variants for existing amethyst blocks, adding more diversity and aesthetic options for your creative projects.

- **Full PBR Support:** Experience next-level realism with Physically Based Rendering (PBR) support, making amethyst blocks react to light in a more physically accurate and visually stunning way.

- **Emissive Support:** Watch your amethyst gleam and glow! With emissive support (requires OptiFine or a similar Fabric-based mod), amethyst clusters and blocks will subtly emit light, enhancing their magical allure.

- **Optimized Performance:** Designed for a beautiful experience without sacrificing significant performance.

## Requirements

- **Minecraft Java Edition 1.17+** (Amethyst was introduced in 1.17)

- **For Emissive & PBR Support:**
  
  - **OptiFine** (Recommended for Forge/Vanilla)
  
  - Or a **Fabric-based equivalent** (e.g., Sodium, Iris Shaders, and Indium for PBR/Emissive features)

## Installation

1. **Download** the resource pack file.

2. **Open Minecraft** and navigate to "Options" -> "Resource Packs" -> "Open Pack Folder".

3. **Drag and Drop** the downloaded `.zip` file into the resource packs folder.

4. **Activate** the resource pack from within Minecraft by moving it from the "Available Resource Packs" to the "Selected Resource Packs" column. Ensure it is above any other packs that might modify amethyst blocks.

5. **For PBR & Emissive Features:**
   
   - **Install OptiFine** or the necessary Fabric mods (Sodium, Iris, Indium).
   
   - Ensure "Shaders" are enabled and configured correctly if using a shader pack that supports PBR.
   
   - Adjust in-game video settings as needed for emissive textures (usually found under "Details" or "Quality" in OptiFine).

6. **Enjoy!**

## Compatibility

This resource pack is designed for Minecraft Java Edition 1.17 and later. While it should be compatible with most other resource packs, ensure "Evol's 3D Amethyst" is placed higher in your resource pack list if you experience conflicts with other packs that modify amethyst blocks.

## Support & Feedback

Encountered an issue? Have a suggestion for a new amethyst variant? Or just want to show off your dazzling amethyst builds? Please reach out via [mention your preferred contact method here, e.g., a specific forum thread, Discord, GitHub issues]. Your input helps us make this pack even more spectacular!

## Changelog

### Version 1.0.0 (Initial Release)

- Initial release of Evol's 3D Amethyst.

- Implemented full 3D models for all amethyst panel stages (budding, medium, large, cluster).

- Introduced updated, high-resolution textures for all amethyst blocks.

- Added new visual block variants for existing amethyst blocks (e.g., smooth amethyst blocks, carved amethyst).

- Integrated full PBR (Physically Based Rendering) support for all amethyst-related textures.

- Added emissive texture support for amethyst clusters and glowing elements (requires OptiFine or Fabric PBR/Emissive mods).

---

Thank you for choosing **Evol's 3D Amethyst**! We hope you love exploring your newly enhanced and radiant amethyst geodes!
