#version 330 compatibility

#define COLEN // Whether to apply the color filter
#define COLS 32.0 // The amount of colors [1.0 2.0 4.0 8.0 16.0 32.0]
#define MODE 1.0 // How the colors are changed [0.0 1.0]
#define PIXEN // Whether to apply the pixel filter
#define SCALE 2.0 // Scale of pixels [ 2.0 4.0 8.0 16.0 32.0 ]

uniform sampler2D colortex0;

in vec2 texcoord;
uniform float viewHeight;
uniform float viewWidth;

/* RENDERTARGETS: 0 */
layout(location = 0) out vec4 color;
vec3 rgb2hsv(vec3 c) {
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}
// All components are in the range [0…1], including hue.
vec3 hsv2rgb(vec3 c) {
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}
float cram(float x, float num) {
	return round(x * num)/num;
}
void main() {
#ifdef PIXEN
	float xres = viewWidth/SCALE;
	float yres = viewHeight/SCALE;
	float x = floor(texcoord.x*xres)/xres;
	float y = floor(texcoord.y*yres)/yres;
   	vec3 incolor = texture(colortex0, vec2(x, y)).rgb;
#else
   	vec3 incolor = texture(colortex0, texcoord).rgb;
#endif
#ifdef COLEN
	if (MODE == 0) {
   		incolor = vec3(cram(incolor.r, COLS), cram(incolor.g, COLS), cram(incolor.b, COLS));
   	} else {
		vec3 hsv = rgb2hsv(incolor);
		incolor = hsv2rgb(vec3(cram(hsv.x, COLS), cram(hsv.y, COLS), cram(hsv.z, COLS)));
	}
#endif
	color = vec4(incolor, 1.0);
}
/*
composite.fsh: composite.fsh: 0:23(7): error: `x' redeclared
0:24(43): error: `y' undeclared
0:24(35): error: cannot construct `vec2' from a non-numeric data type
0:24(16): error: no matching function for call to `texture(sampler2D, error)'; candidates are:
0:24(16): error:    vec4 texture(sampler1D, float)
0:24(16): error:    ivec4 texture(isampler1D, float)
0:24(16): error:    uvec4 texture(usampler1D, float)
0:24(16): error:    vec4 texture(sampler2D, vec2)
0:24(16): error:    ivec4 texture(isampler2D, vec2)
0:24(16): error:    uvec4 texture(usampler2D, vec2)
0:24(16): error:    vec4 texture(sampler3D, vec3)
0:24(16): error:    ivec4 texture(isampler3D, vec3)
0:24(16): error:    uvec4 texture(usampler3D, vec3)
0:24(16): error:    vec4 texture(samplerCube, vec3)
0:24(16): error:    ivec4 texture(isamplerCube, vec3)
0:24(16): error:    uvec4 texture(usamplerCube, vec3)
0:24(16): error:    float texture(sampler1DShadow, vec3)
0:24(16): error:    float texture(sampler2DShadow, vec3)
0:24(16): error:    float texture(samplerCubeShadow, vec4)
0:24(16): error:    vec4 texture(sampler1DArray, vec2)
0:24(16): error:    ivec4 texture(isampler1DArray, vec2)
0:24(16): error:    uvec4 texture(usampler1DArray, vec2)
0:24(16): error:    vec4 texture(sampler2DArray, vec3)
0:24(16): error:    ivec4 texture(isampler2DArray, vec3)
0:24(16): error:    uvec4 texture(usampler2DArray, vec3)
0:24(16): error:    float texture(sampler1DArrayShadow, vec3)
0:24(16): error:    float texture(sampler2DArrayShadow, vec4)
0:24(16): error:    vec4 texture(sampler2DRect, vec2)
0:24(16): error:    ivec4 texture(isampler2DRect, vec2)
0:24(16): error:    uvec4 texture(usampler2DRect, vec2)
0:24(16): error:    float texture(sampler2DRectShadow, vec3)
0:24(16): error:    vec4 texture(sampler1D, float, float)
0:24(16): error:    ivec4 texture(isampler1D, float, float)
0:24(16): error:    uvec4 texture(usampler1D, float, float)
0:24(16): error:    vec4 texture(sampler2D, vec2, float)
0:24(16): error:    ivec4 texture(isampler2D, vec2, float)
0:24(16): error:    uvec4 texture(usampler2D, vec2, float)
0:24(16): error:    vec4 texture(sampler3D, vec3, float)
0:24(16): error:    ivec4 texture(isampler3D, vec3, float)
0:24(16): error:    uvec4 texture(usampler3D, vec3, float)
0:24(16): error:    vec4 texture(samplerCube, vec3, float)
0:24(16): error:    ivec4 texture(isamplerCube, vec3, float)
0:24(16): error:    uvec4 texture(usamplerCube, vec3, float)
0:24(16): error:    float texture(sampler1DShadow, vec3, float)
0:24(16): error:    float texture(sampler2DShadow, vec3, float)
0:24(16): error:    float texture(samplerCubeShadow, vec4, float)
0:24(16): error:    vec4 texture(sampler1DArray, vec2, float)
0:24(16): error:    ivec4 texture(isampler1DArray, vec2, float)
0:24(16): error:    uvec4 texture(usampler1DArray, vec2, float)
0:24(16): error:    vec4 texture(sampler2DArray, vec3, float)
0:24(16): error:    ivec4 texture(isampler2DArray, vec3, float)
0:24(16): error:    uvec4 texture(usampler2DArray, vec3, float)
0:24(16): error:    float texture(sampler1DArrayShadow, vec3, float)
0:24(16): error: type mismatch
0:25(14): warning: `incolor' used uninitialized

*/ 