package shuangjiangguyi.fast_container_placement;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2262;
import net.minecraft.class_2287;
import net.minecraft.class_2290;
import net.minecraft.class_2319;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2627;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import net.minecraft.class_9276;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

import static java.lang.Math.max;
import static java.lang.Math.min;
import static net.minecraft.class_2170.method_9244;

public class FastContainerPlacement implements ModInitializer {
	public static final String MOD_ID = "fast-container-placement";

	public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
		dispatcher.register(class_2170.method_9247("placetocontainer")
				.then(method_9244("pos1", class_2262.method_9698())
						.then(method_9244("pos2", class_2262.method_9698())
								.then(method_9244("placement", LootableContainerBlockStateArgumentType.lootableContainerBlockState())
										.then(method_9244("item", class_2287.method_9776(registryAccess))
												.then(method_9244("count", IntegerArgumentType.integer())
														.executes(context -> {
																	if (context.getSource().method_44023() != null) {
																		final class_2338 pos1 = class_2262.method_48299(context, "pos1");
																		final class_2338 pos2 = class_2262.method_48299(context, "pos2");
																		final class_2248 block = LootableContainerBlockStateArgumentType.getLootableContainerBlockState(context, "placement").method_26204();
																		final class_2290 item = class_2287.method_9777(context, "item");
																		int count = IntegerArgumentType.getInteger(context, "count");
																		class_2168 source = context.getSource();
																		List<class_1799> inventory = new ArrayList<>();
																		for (int i = 0; i < source.method_44023().method_31548().method_5439(); i++) {
																			inventory.add(source.method_44023().method_31548().method_5438(i));
																		}
																		executes(count, context, item, pos1, pos2, block, inventory, source.method_44023());
																	} else throw new SimpleCommandExceptionType(class_2561.method_43471("throw.not_player")).create();
																	return 1;
																}
														)
														.then(method_9244("blockpos", class_2262.method_9698())
																.executes(context -> {
																	final class_2338 pos1 = class_2262.method_48299(context, "pos1");
																	final class_2338 pos2 = class_2262.method_48299(context, "pos2");
																	final class_2248 block = LootableContainerBlockStateArgumentType.getLootableContainerBlockState(context, "placement").method_26204();
																	final class_2338 blockPos = class_2262.method_48299(context, "blockpos");
																	final class_2290 item = class_2287.method_9777(context, "item");
																	int count = IntegerArgumentType.getInteger(context, "count");
																	class_2168 source = context.getSource();
																	List<class_1799> inventory = new ArrayList<>();
																	if (source.method_9225().method_8321(blockPos) instanceof class_2621 lootableContainerBlockEntity) {
																		for (int i = 0; i < lootableContainerBlockEntity.method_5439(); i++) {
																			inventory.add(lootableContainerBlockEntity.method_5438(i));
																		}
																		executes(count, context, item, pos1, pos2, block, inventory, blockPos);
																	}
																	return 1;
																}))
												))))));
		dispatcher.register(class_2170.method_9247("placetocontainer")
				.requires(source -> source.method_9259(2))
				.then(method_9244("pos1", class_2262.method_9698())
						.then(method_9244("pos2", class_2262.method_9698())
								.then(method_9244("placement", LootableContainerBlockStateArgumentType.lootableContainerBlockState())
										.then(method_9244("item", class_2287.method_9776(registryAccess))
												.then(method_9244("count", IntegerArgumentType.integer())
														.then(method_9244("player", class_2186.method_9305())
																.executes(context -> {
																	final class_2338 pos1 = class_2262.method_48299(context, "pos1");
																	final class_2338 pos2 = class_2262.method_48299(context, "pos2");
																	final class_2248 block = LootableContainerBlockStateArgumentType.getLootableContainerBlockState(context, "placement").method_26204();
																	final class_2290 item = class_2287.method_9777(context, "item");
																	int count = IntegerArgumentType.getInteger(context, "count");
																	class_2168 source = context.getSource();
																	class_1657 player = class_2186.method_9315(context, "player");
																	List<class_1799> inventory = new ArrayList<>();
																	for (int i = 0; i < player.method_31548().method_5439(); i++) {
																		inventory.add(player.method_31548().method_5438(i));
																	}
																	executes(count, context, item, pos1, pos2, block, inventory, player);
																	if (!player.equals(source.method_44023())) {
																		if (source.method_44023() != null) {
																			player.method_7353(class_2561.method_30163(
																					class_2561.method_43471("message").getString().formatted(source.method_44023().method_5477().getString(), blockPosToString(pos1), blockPosToString(pos2))), true);
																		}
																	}
																	return 1;
																})
														)))))));
	}

	private static void executes(int count, CommandContext<class_2168> context, class_2290 item, class_2338 pos1, class_2338 pos2, class_2248 block, List<class_1799> inventory, Object posOrPlayer) throws CommandSyntaxException {
		int count2 = 0;
		List<Integer> shulkerBoxSlots = new ArrayList<>();
		List<Integer> bundleSlots = new ArrayList<>();

		for (int i = 0; i < inventory.size(); i++) {
			if (inventory.get(i).method_31574(item.method_9785())) {
				count2 += inventory.get(i).method_7947();
			} else if (inventory.get(i).method_31573(class_3489.field_54293)) {
				shulkerBoxSlots.add(i);
			} else if (inventory.get(i).method_31573(class_3489.field_54294)) {
				bundleSlots.add(i);
			}
		}
		if (!shulkerBoxSlots.isEmpty()) {
			for (int i : shulkerBoxSlots) {
				List<class_1799> itemStacks = Objects.requireNonNull(inventory.get(i).method_57824(class_9334.field_49622)).method_57489().toList();
				for (class_1799 itemStack : itemStacks) {
					if (itemStack.method_31574(item.method_9785())) {
						count2 += itemStack.method_7947();
					}
				}
			}
		}
		if (!bundleSlots.isEmpty()) {
			for (int i : bundleSlots) {
				List<class_1799> itemStacks = Objects.requireNonNull(inventory.get(i).method_57824(class_9334.field_49650)).method_59707().toList();
				for (class_1799 itemStack : itemStacks) {
					if (itemStack.method_31574(item.method_9785())) {
						count2 += itemStack.method_7947();
					}
				}
			}
		}
		if (count2 >= count) {
			for (int x = min(pos1.method_10263(), pos2.method_10263()); x <= max(pos1.method_10263(), pos2.method_10263()); x++) {
				for (int y = min(pos1.method_10264(), pos2.method_10264()); y <= max(pos1.method_10264(), pos2.method_10264()); y++) {
					for (int z = min(pos1.method_10260(), pos2.method_10260()); z <= max(pos1.method_10260(), pos2.method_10260()); z++) {
						class_2338 pos = new class_2338(x, y, z);
						class_2586 blockEntity = context.getSource().method_9225().method_8321(pos);
						if (blockEntity instanceof class_2621) {
							incrementCountInHasInventoryBlock(context.getSource(), pos, item, count, block, inventory, posOrPlayer);
						}
					}
				}
			}
		} else if (!Objects.requireNonNull(context.getSource().method_44023()).method_56992()) {
			throw new SimpleCommandExceptionType(class_2561.method_43471("throw.insufficient")).create();
		}
	}

	public static void incrementCountInHasInventoryBlock(@NotNull class_2168 source, class_2338 pos, class_2290 item, int count, class_2248 block, List<class_1799> inventory, Object posOrPlayer) throws CommandSyntaxException {
		if (source.method_9225().method_8320(pos).method_27852(block)) {
			class_2621 blockEntity = (class_2621) source.method_9225().method_8321(pos);
			boolean isFull = true;
			int count1 = 0;
			List<Integer> shulkerBoxSlots = new ArrayList<>();
			List<Integer> bundleSlots = new ArrayList<>();
			for (int i = 0; i < inventory.size(); i++) {
				if (inventory.get(i).method_31574(item.method_9785()) && inventory.get(i).method_57353().equals(inventory.get(i).method_58658())) {
					count1 += inventory.get(i).method_7947();
				} else if (inventory.get(i).method_31573(class_3489.field_54293) && inventory.get(i).method_57353().method_57829(class_9334.field_49622) != null) {
					shulkerBoxSlots.add(i);
				} else if (inventory.get(i).method_31573(class_3489.field_54294) && inventory.get(i).method_57353().method_57829(class_9334.field_49650) != null) {
					bundleSlots.add(i);
				}
			}
			if (!shulkerBoxSlots.isEmpty()) {
				for (int i : shulkerBoxSlots) {
					List<class_1799> itemStacks = Objects.requireNonNull(inventory.get(i).method_57824(class_9334.field_49622)).method_57489().toList();
					for (class_1799 itemStack : itemStacks) {
						if (itemStack.method_31574(item.method_9785())) {
							count1 += itemStack.method_7947();
						}
					}
				}
			}
			if (!bundleSlots.isEmpty()) {
				for (int i : bundleSlots) {
					List<class_1799> itemStacks = Objects.requireNonNull(inventory.get(i).method_57824(class_9334.field_49650)).method_59707().toList();
					for (class_1799 itemStack : itemStacks) {
						if (itemStack.method_31574(item.method_9785())) {
							count1 += itemStack.method_7947();
						}
					}
				}
			}
			if (!(count1 < count)) {
				if (blockEntity != null) {
					for (int i = 0; i < blockEntity.method_5439(); i++) {
						if (blockEntity.method_5438(i).method_7960() ||
								(blockEntity.method_5438(i).method_7947() != blockEntity.method_5438(i).method_7914())) {
							isFull = false;
						}
					}
				}
				if (!isFull) {
					List<Integer> canContainerItemSlots = new ArrayList<>();
					for (int i = 0; i < blockEntity.method_5439(); i++) {
						if (blockEntity.method_5438(i).method_7960() || blockEntity.method_5438(i).method_7947() != blockEntity.method_5438(i).method_7914() &&
								blockEntity.method_5438(i).method_31574(item.method_9785())) {
							if (blockEntity instanceof class_2627) {
								if (!new class_1799(item.method_9785()).method_31573(class_3489.field_54293)) {
									canContainerItemSlots.add(i);
								}
							} else {
								canContainerItemSlots.add(i);
							}
						}
					}
					int canContainerItemSlotsCount = 0;
					for (int itemStack : canContainerItemSlots) {
						canContainerItemSlotsCount += blockEntity.method_5438(itemStack).method_7914() -
								blockEntity.method_5438(itemStack).method_7947();
					}
					if (!canContainerItemSlots.isEmpty()) {
						if (canContainerItemSlotsCount >= count) {
							int count2 = count;
							if (Objects.requireNonNull(source.method_44023()).method_56992()) {
								for (int i = 0; i < inventory.size(); i++) {
									if (count2 == 0) break;
									if (inventory.get(i).method_31574(item.method_9785())) {
										if (count2 < inventory.get(i).method_7947()) {
											inventory.get(i).method_7934(count2);
											count2 = 0;
										} else {
											count2 -= inventory.get(i).method_7947();
											inventory.set(i, class_1799.field_8037);
										}
									} else if (inventory.get(i).method_31573(class_3489.field_54293)) {
										List<class_1799> temp = new ArrayList<>();
										List<class_1799> itemStacks = new ArrayList<>(Objects.requireNonNull(inventory.get(i).method_57824(class_9334.field_49622)).method_57489().toList());
										for (class_1799 itemStack : itemStacks) {
											if (itemStack.method_31574(item.method_9785()) && itemStack.method_57353().equals(item.method_9785().method_57347())) {
												if (count2 < itemStack.method_7947()) {
													itemStack.method_7934(count2);
													count2 = 0;
												} else {
													count2 -= itemStack.method_7947();
													temp.add(itemStack);
												}
											}
										}
										if (!temp.isEmpty()) {
											for (class_1799 itemStack : temp) {
												itemStacks.remove(itemStack);
											}
										}
										class_1799 stack = inventory.get(i).method_7972();
										stack.method_57379(class_9334.field_49622, class_9288.method_57493(itemStacks));
										inventory.set(i, stack);
									} else if (inventory.get(i).method_31573(class_3489.field_54294)) {
										List<class_1799> temp = new ArrayList<>();
										List<class_1799> itemStacks = new ArrayList<>(Objects.requireNonNull(inventory.get(i).method_57824(class_9334.field_49650)).method_59707().toList());
										for (class_1799 itemStack : itemStacks) {
											if (itemStack.method_31574(item.method_9785()) && itemStack.method_57353().equals(item.method_9785().method_57347())) {
												if (count2 < itemStack.method_7947()) {
													itemStack.method_7934(count2);
													count2 = 0;
												} else {
													count2 -= itemStack.method_7947();
													temp.add(itemStack);
												}
											}
										}
										if (!temp.isEmpty()) {
											for (class_1799 itemStack : temp) {
												itemStacks.remove(itemStack);
											}
										}
										class_1799 stack = inventory.get(i).method_7972();
										stack.method_57379(class_9334.field_49650, new class_9276(itemStacks));
										inventory.set(i, stack);
									}
								}
							}

							for (int itemStack : canContainerItemSlots) {
								if (count == 0) {
									break;
								}
								if (count > blockEntity.method_5438(itemStack).method_7914() - blockEntity.method_5438(itemStack).method_7947()) {
									for (int i = 0; i < blockEntity.method_5438(itemStack).method_7914() -
											(blockEntity.method_5438(itemStack).method_7947()); i++) {
										blockEntity.method_5438(itemStack).method_7933(blockEntity.method_5438(itemStack).method_7914() -
												(blockEntity.method_5438(itemStack).method_7947()));
									}
									count -= blockEntity.method_5438(itemStack).method_7914() - blockEntity.method_5438(itemStack).method_7947();
								} else {
									blockEntity.method_5447(itemStack, new class_1799(item.method_9785(), blockEntity.method_5438(itemStack).method_7947() + count));
									count = 0;
								}
							}
						}
					} else {
						throw new SimpleCommandExceptionType(class_2561.method_30163(class_2561.method_43471("throw.container_is_full").getString().formatted(blockPosToString(blockEntity.method_11016())))).create();
					}
				}
			} else if (Objects.requireNonNull(source.method_44023()).method_56992()) {
				throw new SimpleCommandExceptionType(class_2561.method_43471("throw.insufficient")).create();
			}
			if (posOrPlayer instanceof class_1657 player) {
				for (int i = 0; i < inventory.size(); i++) {
					player.method_31548().method_5447(i, inventory.get(i));
				}
			} else if (posOrPlayer instanceof class_2338 pos1) {
				class_1937 world = source.method_9225();
				class_2621 blockEntity1 = (class_2621) world.method_8321(pos1);
				for (int i = 0; i < inventory.size(); i++) {
					if (blockEntity1 != null) {
						blockEntity1.method_5447(i, inventory.get(i));
					}
				}
			}
		}
	}

	@Override
	public void onInitialize() {
		ArgumentTypeRegistry.registerArgumentType(
				class_2960.method_60655(MOD_ID, "lootable_container_block_state"),
				LootableContainerBlockStateArgumentType.class, class_2319.method_41999(LootableContainerBlockStateArgumentType::lootableContainerBlockState));
	}

	private static class LootableContainerBlockStateArgumentType implements ArgumentType<class_2680> {
		public static LootableContainerBlockStateArgumentType lootableContainerBlockState() {
			return new LootableContainerBlockStateArgumentType();
		}

		public static <S> class_2680 getLootableContainerBlockState(CommandContext<S> context, String name) {
			return context.getArgument(name, class_2680.class);
		}

		@Override
		public class_2680 parse(StringReader reader) {
			int argBeginning = reader.getCursor();
			if (!reader.canRead()) {
				reader.skip();
			}
			while (reader.canRead() && reader.peek() != ' ') {
				reader.skip();
			}
			StringBuilder string = new StringBuilder(reader.getString().substring(argBeginning, reader.getCursor()));
			String modId = String.valueOf(string.delete(string.indexOf(":"), string.length()));
			String blockId = String.valueOf(string.delete(0, string.indexOf(":") + 1));
			class_2248 block = class_7923.field_41175.method_63535(class_2960.method_60655(modId, blockId));
			return block.method_9564();
		}

		@Override
		public Collection<String> getExamples() {
			List<String> examples = new ArrayList<>();
			for (class_2248 b : class_7923.field_41175) {
				StringBuilder modId = new StringBuilder(b.method_63499()).delete(0, 6);
				modId.delete(modId.indexOf("."), modId.length());
				StringBuilder blockId = new StringBuilder(b.method_63499()).delete(0, 6);
				blockId.delete(0, blockId.indexOf(".") + 1);
				if (b instanceof class_2237 block1) {
					if (block1.method_10123(new class_2338(0, 0, 0), b.method_9564()) instanceof class_2621) {
						examples.add(modId.append(":").append(blockId).toString());
					}
				}
			}
			return examples;
		}

		@Override
		public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
			class_2378<class_2248> blocks = class_7923.field_41175;

			for (class_2248 block : blocks) {
				StringBuilder modId = new StringBuilder(block.method_63499()).delete(0, 6);
				modId.delete(modId.indexOf("."), modId.length());
				StringBuilder blockId = new StringBuilder(block.method_63499()).delete(0, 6);
				blockId.delete(0, blockId.indexOf(".") + 1);
				if (block instanceof class_2237 block1) {
					if (block1.method_10123(new class_2338(0, 0, 0), block.method_9564()) instanceof class_2621) {
						builder.suggest(modId.append(":").append(blockId).toString());
					}
				}
			}

			return builder.buildFuture();
		}
	}
	private static String blockPosToString(class_2338 pos) {
		return "(x:" + pos.method_10263() + ", y:" + pos.method_10264() + ", z:" + pos.method_10260() + ")";
	}
}