/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.event;

import com.handy.playertitle.constants.BuffType;
import com.handy.playertitle.constants.TitleConstants;
import com.handy.playertitle.entity.TitleBuff;
import com.handy.playertitle.entity.TitlePlayer;
import com.handy.playertitle.lib.BaseConstants;
import com.handy.playertitle.lib.CollUtil;
import com.handy.playertitle.service.TitleBuffService;
import com.handy.playertitle.service.TitlePlayerService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class PlayerTitleBuffEvent
extends Event {
    private static final HandlerList HANDLERS = new HandlerList();
    private final Player player;
    private final Map<String, List<TitleBuff>> titleBuffMap;
    private final List<TitleBuff> titleBuffList;
    private final boolean isAllBuff;

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    public PlayerTitleBuffEvent(Player player) {
        super(!Bukkit.isPrimaryThread());
        this.player = player;
        this.isAllBuff = BaseConstants.CONFIG.getBoolean("isAllBuff");
        TitlePlayer titlePlayer = TitleConstants.TITLE_PLAYER_BUFF_MAP.get(player.getUniqueId());
        if (titlePlayer == null && !this.isAllBuff) {
            this.titleBuffList = new ArrayList<TitleBuff>();
            this.titleBuffMap = new HashMap<String, List<TitleBuff>>();
            return;
        }
        this.titleBuffList = this.isAllBuff ? TitlePlayerService.getInstance().findPlayerAllBuff(player.getUniqueId()) : TitleBuffService.getInstance().findByTitleId(titlePlayer.getTitleId());
        if (CollUtil.isNotEmpty(this.titleBuffList)) {
            for (TitleBuff titleBuff : this.titleBuffList) {
                BuffType buffType = BuffType.getType(titleBuff.getBuffType());
                titleBuff.setPluginName(buffType.getPluginName());
            }
            this.titleBuffMap = this.titleBuffList.stream().collect(Collectors.groupingBy(TitleBuff::getPluginName));
        } else {
            this.titleBuffMap = new HashMap<String, List<TitleBuff>>();
        }
    }

    public List<TitleBuff> getMyPluginBuffType(String pluginName) {
        return this.titleBuffMap.get(pluginName);
    }

    public Player getPlayer() {
        return this.player;
    }

    public List<TitleBuff> getTitleBuffList() {
        return this.titleBuffList;
    }

    public boolean isAllBuff() {
        return this.isAllBuff;
    }

    public Map<String, List<TitleBuff>> getTitleBuffMap() {
        return this.titleBuffMap;
    }

    public static void callEvent(Player player) {
        Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerTitleBuffEvent(player));
    }
}

