/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.event;

import com.handy.playertitle.constants.TitleUseTypeEnum;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class PlayerUseTitleEvent
extends Event {
    private static final HandlerList HANDLERS = new HandlerList();
    private final Player player;
    private final Integer titleId;
    private final TitleUseTypeEnum useType;
    private final boolean isUse;

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    public PlayerUseTitleEvent(Player player, Integer titleId, TitleUseTypeEnum useType, boolean isUse) {
        super(!Bukkit.isPrimaryThread());
        this.player = player;
        this.titleId = titleId;
        this.useType = useType;
        this.isUse = isUse;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Integer getTitleId() {
        return this.titleId;
    }

    public TitleUseTypeEnum getUseType() {
        return this.useType;
    }

    public boolean isUse() {
        return this.isUse;
    }

    public static void callEvent(Player player, Integer titleId, TitleUseTypeEnum useType, boolean isUse) {
        Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerUseTitleEvent(player, titleId, useType, isUse));
    }
}

