/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.hook;

import com.handy.playertitle.PlayerTitle;
import com.handy.playertitle.constants.TitleConstants;
import com.handy.playertitle.constants.TitleUseTypeEnum;
import com.handy.playertitle.entity.TitlePlayer;
import com.handy.playertitle.lib.BaseConstants;
import com.handy.playertitle.lib.BaseUtil;
import com.handy.playertitle.lib.CollUtil;
import com.handy.playertitle.lib.DateUtil;
import com.handy.playertitle.lib.MapUtil;
import com.handy.playertitle.lib.NumberUtil;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.util.TitleUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class PlaceholderUtil
extends PlaceholderExpansion {
    private final PlayerTitle plugin;

    public PlaceholderUtil(PlayerTitle plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "playerTitle";
    }

    public String onRequest(OfflinePlayer player, @NotNull String identifier) {
        if (player == null) {
            return null;
        }
        if ("number".equals(identifier)) {
            int count = TitlePlayerService.getInstance().findCount(player.getUniqueId());
            return String.valueOf(count);
        }
        if ("coin".equals(identifier)) {
            return TitleUtil.getTitleCoin(player.getUniqueId());
        }
        if (identifier.contains("count")) {
            String titleId = identifier.replace("count_", "");
            int count = TitlePlayerService.getInstance().findCount(NumberUtil.isNumericToInt(titleId, 0));
            return String.valueOf(count);
        }
        if (identifier.contains("have")) {
            String titleId = identifier.replace("have_", "");
            Optional<TitlePlayer> titlePlayerOptional = TitlePlayerService.getInstance().findByPlayerAndTitleId(player.getUniqueId(), NumberUtil.isNumericToInt(titleId, 0));
            return BaseUtil.getLangMsg(titlePlayerOptional.isPresent() ? "haveTrue" : "haveFalse");
        }
        String[] split = identifier.split("_");
        TitleUseTypeEnum useType = TitleUseTypeEnum.SHOW;
        if (split.length > 1) {
            useType = TitleUseTypeEnum.getByUseType(split[1]);
        }
        TitlePlayer titlePlayer = null;
        switch (useType) {
            case SHOW: {
                titlePlayer = TitleConstants.TITLE_PLAYER_SHOW_MAP.get(player.getUniqueId());
                break;
            }
            case BUFF: {
                titlePlayer = TitleConstants.TITLE_PLAYER_BUFF_MAP.get(player.getUniqueId());
                break;
            }
            case PARTICLE: {
                titlePlayer = TitleConstants.TITLE_PLAYER_PARTICLE_MAP.get(player.getUniqueId());
                break;
            }
        }
        if (titlePlayer == null) {
            Map<UUID, TitlePlayer> offlineCacheMap = TitleConstants.PLAYER_TITLE_OFFLINE_CACHE_MAP.get(useType.getUseType());
            if (MapUtil.isNotEmpty(offlineCacheMap) && offlineCacheMap.get(player.getUniqueId()) != null) {
                titlePlayer = offlineCacheMap.get(player.getUniqueId());
            } else {
                titlePlayer = TitlePlayerService.getInstance().findByPlayerAndUseType(player.getUniqueId(), useType).orElse(new TitlePlayer());
                TitleConstants.PLAYER_TITLE_OFFLINE_CACHE_MAP.putIfAbsent(useType.getUseType(), MapUtil.of(player.getUniqueId(), titlePlayer));
            }
        }
        boolean isTitlePlayer = titlePlayer != null && titlePlayer.getId() != null;
        switch (identifier) {
            case "use": 
            case "use_buff": 
            case "use_particle": {
                String defaultTitle = isTitlePlayer ? titlePlayer.getTitleName() : BaseConstants.CONFIG.getString("default", "");
                defaultTitle = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)defaultTitle);
                return BaseUtil.replaceChatColor(defaultTitle);
            }
            case "strip_color_use": 
            case "strip_color_use_buff": 
            case "strip_color_use_particle": {
                String stripColorDefaultTitle = isTitlePlayer ? titlePlayer.getTitleName() : BaseConstants.CONFIG.getString("default", "");
                stripColorDefaultTitle = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)stripColorDefaultTitle);
                return BaseUtil.stripColor(stripColorDefaultTitle);
            }
            case "raw_text_use": 
            case "raw_text_use_buff": 
            case "raw_text_use_particle": {
                return isTitlePlayer ? titlePlayer.getTitleName() : BaseConstants.CONFIG.getString("default", "");
            }
            case "description": 
            case "description_buff": 
            case "description_particle": {
                String description = isTitlePlayer ? titlePlayer.getDescription() : BaseUtil.getLangMsg("shop.noBuff");
                return BaseUtil.replaceChatColor(description);
            }
            case "buff": 
            case "buff_buff": 
            case "buff_particle": {
                String buff = BaseUtil.getLangMsg("shop.noBuff");
                if (isTitlePlayer && CollUtil.isNotEmpty(titlePlayer.getTitleBuffs())) {
                    List<String> buffs = TitleUtil.getBuff(titlePlayer.getTitleBuffs());
                    buff = CollUtil.listToStr(buffs);
                }
                return BaseUtil.replaceChatColor(buff);
            }
            case "particle": 
            case "particle_buff": 
            case "particle_particle": {
                String particle = BaseUtil.getLangMsg("shop.noBuff");
                if (isTitlePlayer && titlePlayer.getTitleParticle() != null) {
                    List<String> particleList = TitleUtil.getParticle(titlePlayer.getTitleParticle());
                    particle = CollUtil.listToStr(particleList);
                }
                return BaseUtil.replaceChatColor(particle);
            }
            case "use_id": 
            case "use_buff_id": 
            case "use_particle_id": {
                if (isTitlePlayer) {
                    return titlePlayer.getTitleId().toString();
                }
                return null;
            }
            case "expiration_time": 
            case "expiration_time_buff": 
            case "expiration_time_particle": {
                String expirationTime = BaseUtil.getLangMsg("perpetual");
                if (isTitlePlayer) {
                    expirationTime = DateUtil.format(titlePlayer.getExpirationTime(), "yyyy-MM-dd");
                    if (DateUtil.isPerpetual(titlePlayer.getExpirationTime())) {
                        expirationTime = BaseUtil.getLangMsg("perpetual");
                    }
                }
                return BaseUtil.replaceChatColor(expirationTime);
            }
        }
        return null;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    @NotNull
    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }
}

