/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.hook;

import cn.handyplus.currency.api.PlayerCurrencyApi;
import com.handy.playertitle.PlayerTitle;
import com.handy.playertitle.lib.BaseUtil;
import com.handy.playertitle.lib.MessageUtil;
import com.handy.playertitle.lib.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class PlayerCurrencyUtil {
    public static boolean take(Player player, String type, long price, String operatorReason) {
        if (!PlayerTitle.USE_PLY) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("playerCurrencyFailureMsg"));
            return false;
        }
        return PlayerCurrencyApi.take((UUID)player.getUniqueId(), (String)PlayerCurrencyUtil.replacePrefix(type), (Long)price, (String)"PlayerTitle", (String)operatorReason);
    }

    public static boolean give(Player player, String type, long price, String operatorReason) {
        if (price == 0L) {
            return false;
        }
        if (!PlayerTitle.USE_PLY) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("playerCurrencyFailureMsg"));
            return false;
        }
        return PlayerCurrencyApi.give((UUID)player.getUniqueId(), (String)PlayerCurrencyUtil.replacePrefix(type), (Long)price, (String)"PlayerTitle", (String)operatorReason);
    }

    public static Long look(Player player, String type) {
        if (!PlayerTitle.USE_PLY || player == null || StrUtil.isEmpty(type)) {
            return 0L;
        }
        return PlayerCurrencyApi.look((UUID)player.getUniqueId(), (String)PlayerCurrencyUtil.replacePrefix(type));
    }

    public static String getDesc(String type) {
        if (!PlayerTitle.USE_PLY || StrUtil.isEmpty(type)) {
            return type;
        }
        return PlayerCurrencyApi.getDesc((String)PlayerCurrencyUtil.replacePrefix(type));
    }

    public static List<String> findAllType() {
        if (!PlayerTitle.USE_PLY) {
            return new ArrayList<String>();
        }
        return PlayerCurrencyApi.findAllType().stream().map(s2 -> "ply_" + s2).collect(Collectors.toList());
    }

    private static String replacePrefix(String type) {
        return type.replace("ply_", "");
    }
}

