/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.lib;

import com.handy.playertitle.lib.AssertUtil;
import com.handy.playertitle.lib.BaseConstants;
import com.handy.playertitle.lib.CollUtil;
import com.handy.playertitle.lib.DateUtil;
import com.handy.playertitle.lib.HandyHttpUtil;
import com.handy.playertitle.lib.HookPluginEnum;
import com.handy.playertitle.lib.ItemStackUtil;
import com.handy.playertitle.lib.JsonUtil;
import com.handy.playertitle.lib.LegacyUtil;
import com.handy.playertitle.lib.MessageUtil;
import com.handy.playertitle.lib.NetUtil;
import com.handy.playertitle.lib.PatternUtil;
import com.handy.playertitle.lib.RgbTextUtil;
import com.handy.playertitle.lib.StrUtil;
import com.handy.playertitle.lib.VersionCheckEnum;
import com.handy.playertitle.util.TitleUtil;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class BaseUtil {
    public static void readJsonFileToItemJsonCacheMap(File a2) {
        Optional<String> optional = BaseUtil.readJsonFile(a2);
        if (optional.isPresent()) {
            if (optional.get().length() > 1) {
                try {
                    BaseConstants.ITEM_JSON_CACHE_MAP = JsonUtil.toMap(optional.get());
                    return;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private /* synthetic */ BaseUtil() {
        BaseUtil a2;
    }

    public static Player getOnlinePlayer(CommandSender a2, String a3, String a4) {
        if (StrUtil.isEmpty(a3)) {
            return AssertUtil.notPlayer(a2, a4);
        }
        return BaseUtil.getOnlinePlayer(a3).orElseThrow(() -> new RuntimeException(a4));
    }

    public static boolean hook(String a2, String a3, String a4) {
        Optional<Plugin> optional = BaseUtil.hook(a2);
        MessageUtil.sendConsoleMessage(BaseUtil.getMsgNotColor(optional.isPresent() ? a3 : a4));
        return optional.isPresent();
    }

    public static int getFirstPluginVersion(Plugin a2) {
        return Integer.parseInt(a2.getDescription().getVersion().split(TitleUtil.xXxXXx("\u001c\u001e"))[0]);
    }

    public static OfflinePlayer getOfflinePlayer(String a2) {
        return Bukkit.getOfflinePlayer((String)a2);
    }

    public static String getLangMsg(String a2, String a3, boolean a4) {
        if (StrUtil.isEmpty(a2)) {
            return a3;
        }
        FileConfiguration fileConfiguration = BaseConstants.LANG_CONFIG;
        if (fileConfiguration == null) {
            return a3;
        }
        a3 = fileConfiguration.getString(a2, a3);
        if (a4) {
            return BaseUtil.replaceChatColor(a3);
        }
        return a3;
    }

    public static UUID getUuid(String a2) {
        return Bukkit.getOfflinePlayer((String)a2).getUniqueId();
    }

    public static String stripColor(String a2) {
        if (StrUtil.isEmpty(a2)) {
            return "";
        }
        return ChatColor.stripColor((String)BaseUtil.replaceChatColor(a2));
    }

    public static void readJsonFileToJsonCacheMap(File a3) {
        try {
            Optional<String> optional = BaseUtil.readJsonFile(a3);
            optional.ifPresent(a2 -> {
                BaseConstants.JSON_CACHE_MAP = JsonUtil.toMap(a2);
            });
            return;
        }
        catch (Throwable throwable) {
            MessageUtil.sendConsoleDebugMessage(TitleUtil.xXxXXx("\u8bcb\u5396Y4U-\u001e*C/^\u5f42\u5e08"));
            return;
        }
    }

    public static Boolean isNotPlayer(CommandSender a2) {
        return !BaseUtil.isPlayer(a2).booleanValue();
    }

    public static String replaceChatColor(String a2) {
        if (StrUtil.isEmpty(a2)) {
            return "";
        }
        String string = a2.replace(DateUtil.xXxXXx("j"), TitleUtil.xXxXXx("\u0097"));
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_16.getVersionId()) {
            return string;
        }
        return BaseUtil.H(string);
    }

    public static int getTwoPluginVersion(Plugin a2) {
        return Integer.parseInt(a2.getDescription().getVersion().split(DateUtil.xXxXXx("5b"))[1]);
    }

    public static String getLangMsg(String a2, String a3) {
        return BaseUtil.getLangMsg(a2, a3, true);
    }

    private static /* synthetic */ String H(String a2) {
        Matcher matcher = PatternUtil.RPG_PATTERN.matcher(a2);
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher2 = matcher;
        while (matcher2.find()) {
            String string = matcher.group();
            if (string.length() == 5) {
                string = new StringBuilder().insert(0, string.substring(0, 2)).append(BaseUtil.PPpPPP(string.substring(2))).toString();
            }
            Matcher matcher3 = matcher;
            matcher2 = matcher3;
            matcher3.appendReplacement(stringBuffer, ChatColor.of((String)string.substring(1)).toString());
        }
        matcher.appendTail(stringBuffer);
        return ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)stringBuffer.toString());
    }

    @NotNull
    public static String getDisplayName(ItemStack a2) {
        if (a2 == null) {
            a2 = new ItemStack(Material.AIR);
        }
        ItemStack itemStack = a2;
        Object object = ItemStackUtil.getItemMeta(itemStack);
        String string = itemStack.getType().name();
        if (BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_20_5.getVersionId() && object.hasItemName()) {
            return object.getItemName();
        }
        if (object.hasDisplayName()) {
            return object.getDisplayName();
        }
        if (!BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            object = BaseConstants.JSON_CACHE_MAP.get(new StringBuilder().insert(0, DateUtil.xXxXXx("%\u001d)\u0004b\u0004%\u0007)\n>\b*\u001db")).append(string.toLowerCase()).toString());
            if (object == null) {
                object = BaseConstants.JSON_CACHE_MAP.get(new StringBuilder().insert(0, TitleUtil.xXxXXx("\"\\/S+\u001e-Y.U#B!V4\u001e")).append(string.toLowerCase()).toString());
            }
            if (object != null) {
                return object;
            }
        }
        if (!BaseConstants.ITEM_JSON_CACHE_MAP.isEmpty() && (object = BaseConstants.ITEM_JSON_CACHE_MAP.get(string)) != null) {
            return object;
        }
        if (!BaseConstants.CLOUD_ITEM_JSON_CACHE_MAP.isEmpty()) {
            if (a2.getDurability() > 0 && (object = BaseConstants.CLOUD_ITEM_JSON_CACHE_MAP.get(new StringBuilder().insert(0, string).append(DateUtil.xXxXXx("\u0013")).append(a2.getDurability()).toString())) != null) {
                return object;
            }
            object = BaseConstants.CLOUD_ITEM_JSON_CACHE_MAP.get(string);
            if (object != null) {
                return object;
            }
        }
        return string;
    }

    public static Optional<Player> getOnlinePlayer(String a2) {
        Player player = Bukkit.getPlayerExact((String)a2);
        if (player == null || !player.isOnline()) {
            return Optional.empty();
        }
        return Optional.of(player);
    }

    public static String getColorName(String a2) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return a2;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault(new StringBuilder().insert(0, DateUtil.xXxXXx("\n#\u0005#\u001bb\u0004%\u0007)\n>\b*\u001db")).append(a2.toLowerCase()).toString(), a2);
    }

    public static Optional<Plugin> hook(String a2) {
        Plugin plugin = Bukkit.getPluginManager().getPlugin(a2);
        if (plugin != null && plugin.isEnabled()) {
            return Optional.of(plugin);
        }
        return Optional.empty();
    }

    public static String getMsgNotColor(String a2, String a3) {
        return BaseUtil.getLangMsg(a2, a3, false);
    }

    public static Boolean isPlayer(CommandSender a2) {
        return a2 instanceof Player;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<String> readJsonFile(File a2) {
        StringBuilder stringBuilder;
        InputStreamReader inputStreamReader;
        FileReader fileReader;
        try {
            fileReader = new FileReader(a2);
            inputStreamReader = new InputStreamReader(Files.newInputStream(a2.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
            stringBuilder = new StringBuilder();
            InputStreamReader inputStreamReader2 = inputStreamReader;
            while (true) {
                int n2 = ((Reader)inputStreamReader2).read();
                if (n2 != -1) {
                    inputStreamReader2 = inputStreamReader;
                    stringBuilder.append((char)n2);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            Bukkit.getLogger().log(Level.SEVERE, DateUtil.xXxXXx(">\f-\r\u0006\u001a#\u0007\n\u0000 \fl\u53b8\u7553\u5f6b\u5e74"), exception);
            return Optional.empty();
        }
        {
            fileReader.close();
            ((Reader)inputStreamReader).close();
            return Optional.of(stringBuilder.toString());
        }
    }

    public static boolean hook(HookPluginEnum a2, Integer a3) {
        return BaseUtil.hook(a2.getName(), a2.getSuccessMsg(), a2.getFailMsg(), a3);
    }

    public static String getLangMsg(String a2) {
        return BaseUtil.getLangMsg(a2, "");
    }

    public static void sendTip(CommandSender a2) {
        String string = BaseConstants.CONFIG.getString("signType", "mac");
        String string2 = string = "mac".equalsIgnoreCase(string) ? NetUtil.getLocalMacAddress() : HandyHttpUtil.getIp();
        if (BaseUtil.isPlayer(a2).booleanValue() && BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_15.getVersionId()) {
            RgbTextUtil rgbTextUtil = RgbTextUtil.getInstance().init(string);
            String string3 = BaseUtil.getMsgNotColor(DateUtil.xXxXXx("\n#\u00195"), TitleUtil.xXxXXx("\u00162\u0010`\u0010f\b\u001b\u0016!\u7089\u51bb\u593d\u5276\u0016xm"));
            RgbTextUtil rgbTextUtil2 = rgbTextUtil;
            rgbTextUtil2.addExtra(RgbTextUtil.getInstance().init(string3).addClickCopyToClipboard(string).build());
            rgbTextUtil2.send((Player)a2);
            return;
        }
        MessageUtil.sendMessage(a2, string);
    }

    public static boolean hook(String a2, String a3, String a4, Integer a5) {
        Optional<Object> optional = BaseUtil.hook(a2);
        if (optional.isPresent() && BaseUtil.getFirstPluginVersion(optional.get()) < a5) {
            optional = Optional.empty();
        }
        MessageUtil.sendConsoleMessage(BaseUtil.getMsgNotColor(optional.isPresent() ? a3 : a4));
        return optional.isPresent();
    }

    public static String getEntityName(String a2) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return a2;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault(new StringBuilder().insert(0, TitleUtil.xXxXXx("U.D)D9\u001e-Y.U#B!V4\u001e")).append(a2.toLowerCase()).toString(), a2);
    }

    public static void isPrimaryThread(String a2) {
        if (!BaseConstants.DEBUG) {
            return;
        }
        MessageUtil.sendConsoleMessage(new StringBuilder().insert(0, a2).append(DateUtil.xXxXXx("Sl")).append(Bukkit.isPrimaryThread()).toString());
    }

    public static boolean hook(HookPluginEnum a2) {
        return BaseUtil.hook(a2.getName(), a2.getSuccessMsg(), a2.getFailMsg());
    }

    public static Optional<Biome> getBiome(String a2) {
        try {
            return Optional.of(LegacyUtil.yqGxoj(a2));
        }
        catch (Exception exception) {
            if (BaseConstants.DEBUG) {
                Bukkit.getLogger().log(Level.SEVERE, TitleUtil.xXxXXx("W%D\u0002Y/]%\u0010\u5391\u752f\u5f42\u5e08"), exception);
            }
            return Optional.empty();
        }
    }

    public static Optional<EntityType> getEntityType(String a2) {
        try {
            return Optional.of(EntityType.valueOf((String)a2.toUpperCase()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.empty();
        }
    }

    public static String getMsgNotColor(String a2) {
        return BaseUtil.getMsgNotColor(a2, "");
    }

    public static OfflinePlayer getOfflinePlayer(UUID a2) {
        return Bukkit.getOfflinePlayer((UUID)a2);
    }

    public static Optional<Plugin> hookToPlugin(HookPluginEnum a2) {
        Optional<Plugin> optional = BaseUtil.hook(a2.getName());
        MessageUtil.sendConsoleMessage(BaseUtil.getMsgNotColor(optional.isPresent() ? a2.getSuccessMsg() : a2.getFailMsg()));
        return optional;
    }

    public static String getEffectName(String a2) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return a2;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault(new StringBuilder().insert(0, DateUtil.xXxXXx(")\u000f*\f/\u001db\u0004%\u0007)\n>\b*\u001db")).append(a2.toLowerCase()).toString(), a2);
    }

    public static String getMsgNotColor(String a2, Map<String, String> a3) {
        String string = BaseUtil.getMsgNotColor(a2, "");
        if (a3 != null) {
            Iterator<String> iterator;
            Iterator<String> iterator2 = iterator = a3.keySet().iterator();
            while (iterator2.hasNext()) {
                String string2;
                String string3 = string2 = iterator.next();
                string = string.replace(string3, a3.get(string3));
                iterator2 = iterator;
            }
        }
        return string;
    }

    public static List<String> replaceChatColor(List<String> a2) {
        Iterator<String> iterator;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (CollUtil.isEmpty(a2)) {
            return arrayList;
        }
        Iterator<String> iterator2 = iterator = a2.iterator();
        while (iterator2.hasNext()) {
            String string = iterator.next();
            iterator2 = iterator;
            arrayList.add(BaseUtil.replaceChatColor(string));
        }
        return arrayList;
    }

    public static Optional<Sound> getSound(String a2) {
        try {
            return Optional.of(LegacyUtil.oOoOOO(a2));
        }
        catch (Exception exception) {
            if (BaseConstants.DEBUG) {
                Bukkit.getLogger().log(Level.SEVERE, DateUtil.xXxXXx("+\f8:#\u001c\"\rl\u53b8\u7553\u5f6b\u5e74"), exception);
            }
            return Optional.empty();
        }
    }

    private static /* synthetic */ String PPpPPP(String a2) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = a2.toCharArray();
        int n3 = cArray.length;
        int n4 = n2 = 0;
        while (n4 < n3) {
            char c2 = cArray[n2];
            stringBuilder.append(c2);
            stringBuilder.append(c2);
            n4 = ++n2;
        }
        return stringBuilder.toString();
    }

    public static Integer convertVersion(String a2) {
        int n2;
        String[] stringArray = a2.replaceAll(TitleUtil.xXxXXx("\u001bn\u001cTnm"), "");
        if (!stringArray.contains(".")) {
            return Integer.parseInt((String)stringArray);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringArray = stringArray.split(DateUtil.xXxXXx("5b"));
        int n3 = stringArray.length;
        int n4 = n2 = 0;
        while (n4 < n3) {
            String string = stringArray[n2];
            if (string.length() == 1) {
                stringBuilder.append(TitleUtil.xXxXXx("\u0000"));
            }
            stringBuilder.append(string);
            n4 = ++n2;
        }
        return Integer.parseInt(stringBuilder.toString());
    }

    public static Optional<Player> getOnlinePlayer(UUID a2) {
        Player player = Bukkit.getPlayer((UUID)a2);
        if (player == null || !player.isOnline()) {
            return Optional.empty();
        }
        return Optional.of(player);
    }

    public static String getEnchantmentLevel(String a2) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return a2;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault(new StringBuilder().insert(0, TitleUtil.xXxXXx("%^#X!^4]%^4\u001e,U6U,\u001e")).append(a2).toString(), a2);
    }
}

