/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.lib;

import com.handy.playertitle.lib.AssertUtil;
import com.handy.playertitle.lib.PatternUtil;
import com.handy.playertitle.lib.StrUtil;
import com.handy.playertitle.service.TitleListService;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Optional;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public final class NumberUtil {
    public static Double isNumericToDouble(@NotNull String str, Double def) {
        return NumberUtil.isNumericToBigDecimal(str).map(BigDecimal::doubleValue).orElse(def);
    }

    public static Integer isNumericToInt(@NotNull String str, Integer def) {
        return NumberUtil.isNumericToBigDecimal(str).map(BigDecimal::intValue).orElse(def);
    }

    public static Long isNumericToLong(@NotNull String str, Long def) {
        return NumberUtil.isNumericToBigDecimal(str).map(BigDecimal::longValue).orElse(def);
    }

    public static Long isNumericToLong(@NotNull String str) {
        return NumberUtil.isNumericToLong(str, null);
    }

    public static Double isNumericToDouble(@NotNull String str) {
        return NumberUtil.isNumericToDouble(str, null);
    }

    public static boolean gt(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        if (num1.compareTo(num2) > 0) {
            return true;
        }
        return false;
    }

    public static BigDecimal isNumericToBigDecimal(@NotNull String str, BigDecimal def) {
        if (StrUtil.isEmpty(str)) {
            return def;
        }
        try {
            Matcher matcher = PatternUtil.BIG_DECIMAL_NUMERIC.matcher(str);
            if (matcher.matches()) {
                return new BigDecimal(str);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
        return def;
    }

    public static boolean ge(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        if (num1.compareTo(num2) >= 0) {
            return true;
        }
        return false;
    }

    public static BigDecimal div(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        return num1.divide(num2, 2, RoundingMode.HALF_UP);
    }

    public static Integer isNumericToInt(@NotNull String str) {
        return NumberUtil.isNumericToInt(str, null);
    }

    private /* synthetic */ NumberUtil() {
        NumberUtil a2;
    }

    public static BigDecimal mul(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        num2 = num1.multiply(num2);
        if (num2.scale() > 2) {
            return num2.setScale(2, RoundingMode.HALF_UP);
        }
        return num2;
    }

    public static boolean lt(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        if (num1.compareTo(num2) < 0) {
            return true;
        }
        return false;
    }

    public static String xXxXXx(String a2) {
        int n2 = a2.length();
        int n3 = n2 - 1;
        char[] cArray = new char[n2];
        int n4 = 1 << 3 ^ (3 ^ 5);
        int cfr_ignored_0 = 4 << 4 ^ 1 << 1;
        int n5 = n3;
        int n6 = 4 << 4 ^ 3;
        while (n5 >= 0) {
            int n7 = n3--;
            cArray[n7] = (char)(a2.charAt(n7) ^ n6);
            if (n3 < 0) break;
            int n8 = n3--;
            cArray[n8] = (char)(a2.charAt(n8) ^ n4);
            n5 = n3;
        }
        return new String(cArray);
    }

    public static Optional<BigDecimal> isNumericToBigDecimal(@NotNull String str) {
        return Optional.ofNullable(NumberUtil.isNumericToBigDecimal(str, null));
    }

    public static boolean isValidNumber(Number a2) {
        if (null == a2) {
            return false;
        }
        if (a2 instanceof Double) {
            if (!((Double)a2).isInfinite() && !((Double)a2).isNaN()) {
                return true;
            }
            return false;
        }
        if (a2 instanceof Float) {
            if (!((Float)a2).isInfinite() && !((Float)a2).isNaN()) {
                return true;
            }
            return false;
        }
        return true;
    }

    public static BigDecimal toBigDecimal(Number a2) {
        if (null == a2) {
            return BigDecimal.ZERO;
        }
        Number number = a2;
        AssertUtil.isTrue(NumberUtil.isValidNumber(number), TitleListService.xXxXXx("3G\u0010P\u0018@][\u000e\u0012\u0014\\\u000bS\u0011[\u0019\u0013"));
        if (number instanceof BigDecimal) {
            return (BigDecimal)a2;
        }
        if (a2 instanceof Long) {
            return new BigDecimal((Long)a2);
        }
        if (a2 instanceof Integer) {
            return new BigDecimal((Integer)a2);
        }
        if (a2 instanceof BigInteger) {
            return new BigDecimal((BigInteger)a2);
        }
        return new BigDecimal(a2.toString());
    }

    public static boolean le(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        if (num1.compareTo(num2) <= 0) {
            return true;
        }
        return false;
    }
}

