/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.lib;

import com.handy.playertitle.lib.AssertUtil;
import com.handy.playertitle.lib.PatternUtil;
import com.handy.playertitle.lib.StrUtil;
import com.handy.playertitle.util.TitleMessageUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Optional;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public class NumberUtil {
    private /* synthetic */ NumberUtil() {
        NumberUtil a2;
    }

    public static boolean isValidNumber(Number a2) {
        if (null == a2) {
            return false;
        }
        if (a2 instanceof Double) {
            return !((Double)a2).isInfinite() && !((Double)a2).isNaN();
        }
        if (a2 instanceof Float) {
            return !((Float)a2).isInfinite() && !((Float)a2).isNaN();
        }
        return true;
    }

    public static Double isNumericToDouble(@NotNull String str, Double def) {
        return NumberUtil.isNumericToBigDecimal(str).map(BigDecimal::doubleValue).orElse(def);
    }

    public static Long isNumericToLong(@NotNull String str) {
        return NumberUtil.isNumericToLong(str, null);
    }

    public static Double isNumericToDouble(@NotNull String str) {
        return NumberUtil.isNumericToDouble(str, null);
    }

    public static Optional<BigDecimal> isNumericToBigDecimal(@NotNull String str) {
        return Optional.ofNullable(NumberUtil.isNumericToBigDecimal(str, null));
    }

    public static BigDecimal div(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        return num1.divide(num2, 2, RoundingMode.HALF_UP);
    }

    public static Integer isNumericToInt(@NotNull String str) {
        return NumberUtil.isNumericToInt(str, null);
    }

    public static Integer isNumericToInt(@NotNull String str, Integer def) {
        return NumberUtil.isNumericToBigDecimal(str).map(BigDecimal::intValue).orElse(def);
    }

    public static BigDecimal mul(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        if ((num2 = num1.multiply(num2)).scale() > 2) {
            return num2.setScale(2, RoundingMode.HALF_UP);
        }
        return num2;
    }

    public static boolean le(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        return num1.compareTo(num2) <= 0;
    }

    public static BigDecimal toBigDecimal(Number a2) {
        if (null == a2) {
            return BigDecimal.ZERO;
        }
        Number number = a2;
        AssertUtil.isTrue(NumberUtil.isValidNumber(number), TitleMessageUtil.PPPppP("vjU}]m\u0018vK?QqN~Tv\\>"));
        if (number instanceof BigDecimal) {
            return (BigDecimal)a2;
        }
        if (a2 instanceof Long) {
            return new BigDecimal((Long)a2);
        }
        if (a2 instanceof Integer) {
            return new BigDecimal((Integer)a2);
        }
        if (a2 instanceof BigInteger) {
            return new BigDecimal((BigInteger)a2);
        }
        return new BigDecimal(a2.toString());
    }

    public static boolean ge(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        return num1.compareTo(num2) >= 0;
    }

    public static boolean gt(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        return num1.compareTo(num2) > 0;
    }

    public static boolean lt(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        return num1.compareTo(num2) < 0;
    }

    public static Long isNumericToLong(@NotNull String str, Long def) {
        return NumberUtil.isNumericToBigDecimal(str).map(BigDecimal::longValue).orElse(def);
    }

    public static BigDecimal isNumericToBigDecimal(@NotNull String str, BigDecimal def) {
        if (StrUtil.isEmpty(str)) {
            return def;
        }
        try {
            Matcher matcher = PatternUtil.BIG_DECIMAL_NUMERIC.matcher(str);
            if (matcher.matches()) {
                return new BigDecimal(str);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
        return def;
    }
}

