/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.api;

import com.handy.playertitle.api.param.TitleBuffParam;
import com.handy.playertitle.api.param.TitleListParam;
import com.handy.playertitle.api.param.TitleParticleParam;
import com.handy.playertitle.constants.BuffType;
import com.handy.playertitle.constants.BuffTypeEnum;
import com.handy.playertitle.constants.BuyTypeEnum;
import com.handy.playertitle.constants.TitleConstants;
import com.handy.playertitle.constants.TitleUseTypeEnum;
import com.handy.playertitle.core.buff.BuffManageUtil;
import com.handy.playertitle.entity.TitleBuff;
import com.handy.playertitle.entity.TitleCoin;
import com.handy.playertitle.entity.TitleList;
import com.handy.playertitle.entity.TitleParticle;
import com.handy.playertitle.entity.TitlePlayer;
import com.handy.playertitle.event.PlayerTitleBuffEvent;
import com.handy.playertitle.lib.BaseConstants;
import com.handy.playertitle.lib.BaseUtil;
import com.handy.playertitle.lib.CollUtil;
import com.handy.playertitle.lib.DateUtil;
import com.handy.playertitle.lib.JsonUtil;
import com.handy.playertitle.lib.Page;
import com.handy.playertitle.lib.StrUtil;
import com.handy.playertitle.service.TitleBuffService;
import com.handy.playertitle.service.TitleCoinService;
import com.handy.playertitle.service.TitleListService;
import com.handy.playertitle.service.TitleParticleService;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.util.TitleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlayerTitleApi {
    private PlayerTitleApi() {
    }

    public static PlayerTitleApi getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public boolean addBuffType(@NotNull String buffType, @NotNull String buffTypeName, @NotNull String pluginName) {
        if (StrUtil.isEmpty(buffType) || !TitleConstants.NAME_PATTERN.matcher(buffType).matches()) {
            throw new RuntimeException("\u6ce8\u518c\u5931\u8d25\uff0cBUFF\u7c7b\u578b\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u53ea\u5141\u8bb8 a-zA-Z_");
        }
        Map<String, BuffType> buffTypeMap = BuffType.getBuffTypeMap();
        if (buffTypeMap.containsKey(buffType)) {
            throw new RuntimeException("\u6ce8\u518c\u5931\u8d25\uff0c\u5df2\u7ecf\u6709\u8be5\u7c7b\u578b\u4e86");
        }
        BuffType.put(buffType, buffTypeName, pluginName);
        return true;
    }

    public boolean findByTitleId(@NotNull Integer titleId) {
        Objects.requireNonNull(titleId);
        return TitleListService.getInstance().findById(titleId).isPresent();
    }

    public Optional<TitleList> findTitleById(@NotNull Integer titleId) {
        Objects.requireNonNull(titleId);
        return TitleListService.getInstance().findTitleById(titleId);
    }

    public Integer add(@NotNull TitleListParam titleListParam) {
        if (StrUtil.isEmpty(titleListParam.getBuyType())) {
            BuyTypeEnum buyTypeEnum = titleListParam.getBuyTypeEnum();
            titleListParam.setBuyType(buyTypeEnum.getBuyType());
        }
        if (titleListParam.getIsPrefixAndSuffix() != null && titleListParam.getIsPrefixAndSuffix().booleanValue()) {
            String prefixBrackets = BaseConstants.CONFIG.getString("prefixBrackets");
            String suffixBrackets = BaseConstants.CONFIG.getString("suffixBrackets");
            titleListParam.setTitleName(prefixBrackets + titleListParam.getTitleName() + suffixBrackets);
        }
        if (CollUtil.isNotEmpty(titleListParam.getTitleBuffs())) {
            for (TitleBuffParam titleBuff : titleListParam.getTitleBuffs()) {
                if (!BuffTypeEnum.POTION_EFFECT.equals((Object)titleBuff.getBuffType()) || titleBuff.getPotionEffectParam() == null) continue;
                titleBuff.setBuffContent(JsonUtil.toJson(titleBuff.getPotionEffectParam()));
            }
        }
        return TitleListService.getInstance().add(titleListParam);
    }

    public boolean removeTitle(@NotNull Integer titleId) {
        Objects.requireNonNull(titleId);
        return TitleListService.getInstance().removeById(titleId);
    }

    public boolean addTitleBuff(@NotNull Integer titleId, @NotNull List<TitleBuffParam> titleBuffs) {
        boolean rst = false;
        if (CollUtil.isEmpty(titleBuffs)) {
            return false;
        }
        for (TitleBuffParam titleBuffParam : titleBuffs) {
            TitleBuff titleBuff = new TitleBuff();
            titleBuff.setTitleId(titleId);
            titleBuff.setBuffType(titleBuffParam.getBuffType().getBuffType());
            titleBuff.setBuffContent(titleBuffParam.getBuffContent());
            titleBuff.setDescription(titleBuffParam.getDescription());
            rst = TitleBuffService.getInstance().add(titleBuff);
        }
        return rst;
    }

    public boolean removeTitleBuff(@NotNull Integer titleId) {
        Objects.requireNonNull(titleId);
        return TitleBuffService.getInstance().removeByTitleId(titleId);
    }

    public boolean addTitleParticle(@NotNull Integer titleId, @NotNull TitleParticleParam titleParticleParam) {
        Objects.requireNonNull(titleId);
        Objects.requireNonNull(titleParticleParam);
        TitleParticle titleParticle = new TitleParticle();
        titleParticle.setTitleId(titleId);
        titleParticle.setParticleType(titleParticleParam.getParticleType().getParticleType());
        titleParticle.setSuperTrailsId(titleParticleParam.getSuperTrailsId());
        titleParticle.setWingColor(titleParticleParam.getWingColor());
        titleParticle.setWingContour(titleParticleParam.getWingContour());
        titleParticle.setWingThirdColor(titleParticleParam.getWingThirdColor());
        return TitleParticleService.getInstance().add(titleParticle);
    }

    public boolean removeTitleParticle(@NotNull Integer titleId) {
        Objects.requireNonNull(titleId);
        return TitleParticleService.getInstance().removeByTitleId(titleId);
    }

    public boolean update(@NotNull Integer titleId, @NotNull String titleName, boolean isPrefixAndSuffix) {
        Objects.requireNonNull(titleId);
        Objects.requireNonNull(titleName);
        if (isPrefixAndSuffix) {
            String prefixBrackets = BaseConstants.CONFIG.getString("prefixBrackets");
            String suffixBrackets = BaseConstants.CONFIG.getString("suffixBrackets");
            titleName = prefixBrackets + titleName + suffixBrackets;
        }
        return TitleListService.getInstance().updateName(titleId, titleName);
    }

    public boolean updateDescription(@NotNull Integer titleId, String description) {
        Objects.requireNonNull(titleId);
        return TitleListService.getInstance().updateDescription(titleId, description);
    }

    public boolean set(@NotNull UUID playerUuid, @NotNull Integer titleId, int day) {
        Objects.requireNonNull(playerUuid);
        Objects.requireNonNull(titleId);
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(playerUuid);
        return this.set(offlinePlayer.getName(), offlinePlayer.getUniqueId(), titleId, day);
    }

    public boolean set(@NotNull UUID playerUuid, @NotNull Integer titleId) {
        return this.set(playerUuid, titleId, 0);
    }

    public boolean set(String playerName, @NotNull UUID playerUuid, @NotNull Integer titleId, int day) {
        Objects.requireNonNull(playerUuid);
        Objects.requireNonNull(titleId);
        Optional<TitleList> titleListOptional = TitleListService.getInstance().findById(titleId);
        if (!titleListOptional.isPresent()) {
            return false;
        }
        TitleList titleList = titleListOptional.get();
        String titleName = titleList.getTitleName();
        TitlePlayer titlePlayer = new TitlePlayer();
        titlePlayer.setPlayerName(playerName);
        titlePlayer.setPlayerUuid(playerUuid.toString());
        titlePlayer.setTitleId(titleId);
        titlePlayer.setTitleName(titleName);
        titlePlayer.setIsUseShow(false);
        titlePlayer.setIsUseBuff(false);
        titlePlayer.setIsUseParticle(false);
        titlePlayer.setExpirationTime(DateUtil.getDate(day != 0 ? day : 36500));
        return TitlePlayerService.getInstance().set(titlePlayer);
    }

    public boolean removePlayerTitle(@NotNull UUID playerUuid, @NotNull Integer titleId) {
        Objects.requireNonNull(playerUuid);
        Objects.requireNonNull(titleId);
        return TitlePlayerService.getInstance().removePlayerTitle(playerUuid, titleId);
    }

    public TitlePlayer findByPlayerUuidAndIsUse(@NotNull UUID playerUuid) {
        Objects.requireNonNull(playerUuid);
        return TitleConstants.TITLE_PLAYER_SHOW_MAP.get(playerUuid);
    }

    public TitlePlayer findByPlayerUuidAndIsUseBuff(@NotNull UUID playerUuid) {
        Objects.requireNonNull(playerUuid);
        return TitleConstants.TITLE_PLAYER_BUFF_MAP.get(playerUuid);
    }

    public TitlePlayer findByPlayerUuidAndIsUseParticle(@NotNull UUID playerUuid) {
        Objects.requireNonNull(playerUuid);
        return TitleConstants.TITLE_PLAYER_PARTICLE_MAP.get(playerUuid);
    }

    public Integer getPlayerCoinNum(@NotNull UUID playerUuid) {
        Objects.requireNonNull(playerUuid);
        Optional<TitleCoin> titleCoinOptional = TitleCoinService.getInstance().findByPlayerUuid(playerUuid);
        return titleCoinOptional.isPresent() ? titleCoinOptional.get().getAmount() : 0;
    }

    public boolean addCoin(@NotNull UUID playerUuid, @NotNull Integer amount) {
        Objects.requireNonNull(playerUuid);
        Objects.requireNonNull(amount);
        return TitleCoinService.getInstance().give(playerUuid, amount);
    }

    public boolean subtractCoin(@NotNull UUID playerUuid, @NotNull Integer amount) {
        Objects.requireNonNull(playerUuid);
        Objects.requireNonNull(amount);
        return TitleCoinService.getInstance().take(playerUuid, amount);
    }

    public boolean setCoin(@NotNull UUID playerUuid, @NotNull Integer amount) {
        Objects.requireNonNull(playerUuid);
        Objects.requireNonNull(amount);
        return TitleCoinService.getInstance().set(playerUuid, amount);
    }

    public Integer getPlayerTitleNum(@NotNull UUID playerUuid) {
        Objects.requireNonNull(playerUuid);
        return TitlePlayerService.getInstance().findCount(playerUuid);
    }

    public void removeBuff(@NotNull Player player) {
        if (!BaseConstants.CONFIG.getBoolean("isEnableBuff", true)) {
            return;
        }
        BuffManageUtil.removeBuff(player);
    }

    public void setBuff(@NotNull Player player) {
        PlayerTitleBuffEvent.callEvent(player);
    }

    public boolean playerExistTitleId(@NotNull UUID playerUuid, @NotNull Integer titleId) {
        Objects.requireNonNull(playerUuid);
        Objects.requireNonNull(titleId);
        return TitlePlayerService.getInstance().findByPlayerAndTitleId(playerUuid, titleId).isPresent();
    }

    public List<Integer> findAllTitleIdByPlayerUuid(@NotNull UUID playerUuid) {
        Objects.requireNonNull(playerUuid);
        List<TitlePlayer> titlePlayerList = TitlePlayerService.getInstance().findByPlayer(playerUuid);
        return titlePlayerList.stream().map(TitlePlayer::getTitleId).collect(Collectors.toList());
    }

    public List<TitlePlayer> findPlayerTitle(@NotNull UUID playerUuid) {
        Objects.requireNonNull(playerUuid);
        Page<TitlePlayer> page = TitlePlayerService.getInstance().findPageByPlayer(playerUuid, 1, 9999);
        return page.getRecords();
    }

    public List<TitleList> findShopTitle(UUID playerUuid) {
        List<Integer> playerTitleId = new ArrayList<Integer>();
        if (playerUuid != null) {
            playerTitleId = TitlePlayerService.getInstance().findTitleIdByPlayer(playerUuid);
        }
        Page<TitleList> page = TitleListService.getInstance().findPage(playerTitleId, 1, 9999, false, null);
        return page.getRecords();
    }

    public void playerTitleUse(@NotNull Player player, @NotNull Integer titlePlayerId) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(titlePlayerId);
        TitleUtil.playerTitleUse(player, titlePlayerId, TitleUseTypeEnum.ALL, false);
    }

    private static class SingletonHolder {
        private static final PlayerTitleApi INSTANCE = new PlayerTitleApi();

        private SingletonHolder() {
        }
    }
}

