/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.lib;

import com.handy.playertitle.lib.BaseConstants;
import com.handy.playertitle.lib.MessageUtil;
import com.handy.playertitle.lib.VersionCheckEnum;
import com.handy.playertitle.service.TitleParticleService;
import com.handy.playertitle.util.BackUpUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.GameRule;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Biome;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public final class LegacyUtil {
    private static Class<?> G;
    private static Class<?> b;
    private static Class<?> pPpppP;

    public static Particle getFirework() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Particle.FIREWORK;
        }
        return Particle.valueOf((String)TitleParticleService.PpPpPP("sOgCbIgMfYfVtT~"));
    }

    public static AttributeModifier getAttributeModifier(@NotNull String name, double amount, @NotNull AttributeModifier.Operation operation, @NotNull EquipmentSlot a2) {
        UUID uUID = UUID.randomUUID();
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_21.getVersionId()) {
            return new AttributeModifier(uUID, name, amount, operation, a2);
        }
        return new AttributeModifier(NamespacedKey.fromString((String)uUID.toString()), amount, operation, a2.getGroup());
    }

    public static Particle getDripLava() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Particle.DRIPPING_LAVA;
        }
        return Particle.valueOf((String)BackUpUtil.PpPpPP("xDuFcZ}@}"));
    }

    public static List<String> getEntityTypeList() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_13_2.getVersionId()) {
            return Arrays.stream(EntityType.values()).filter(a2 -> {
                if (a2 != EntityType.UNKNOWN) {
                    return true;
                }
                return false;
            }).map(a2 -> a2.getKey().getKey()).collect(Collectors.toList());
        }
        return Arrays.stream(EntityType.values()).map(EntityType::getName).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static String getEnchantmentKey(@NotNull Enchantment enchantment) {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_12.getVersionId()) {
            return enchantment.getKey().getKey();
        }
        return null;
    }

    public static void setGameRuleValue(@NotNull World world, @NotNull String ruleName, @NotNull Object value) {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_12.getVersionId()) {
            GameRule gameRule = GameRule.getByName((String)ruleName);
            if (gameRule == null) {
                MessageUtil.sendConsoleMessage(new StringBuilder().insert(0, TitleParticleService.PpPpPP("\u4e10\u7579\u89c2\u522c<\u0015")).append(ruleName).append(BackUpUtil.PpPpPP("\u001c\u4e1b\u5b64\u573e\u0012")).toString());
                return;
            }
            if (value instanceof Boolean) {
                world.setGameRule(gameRule, (Object)((Boolean)value));
                return;
            }
            if (value instanceof Integer) {
                world.setGameRule(gameRule, (Object)((Integer)value));
                return;
            }
        }
        world.setGameRuleValue(ruleName, String.valueOf(value));
    }

    public static EntityType getEntityTypeByName(@NotNull String name) {
        return EntityType.fromName((String)name);
    }

    private /* synthetic */ LegacyUtil() {
        LegacyUtil a2;
    }

    public static List<String> getPotionEffectTypeList() {
        return Arrays.stream(PotionEffectType.values()).map(PotionEffectType::getName).collect(Collectors.toList());
    }

    public static Attribute getAttribute(@NotNull String name) {
        if (G == null) {
            return null;
        }
        if (G.isEnum()) {
            try {
                Enum enum_ = Enum.valueOf(G.asSubclass(Enum.class), name);
                return (Attribute)enum_;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(new StringBuilder().insert(0, BackUpUtil.PpPpPP("\u6c9d\u671f\u6242\u5226\u76b8\u5c48\u601b,\u001c")).append(name).toString(), illegalArgumentException);
            }
        }
        try {
            Class[] classArray = new Class[1];
            classArray[0] = String.class;
            Method method = G.getMethod(TitleParticleService.PpPpPP("CgYsPIS"), classArray);
            Object[] objectArray = new Object[1];
            objectArray[0] = name;
            return (Attribute)method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(new StringBuilder().insert(0, BackUpUtil.PpPpPP("\u6cb7\u6735\u6268\u520c\u5c48\u601b,\u001c")).append(name).toString(), exception);
        }
    }

    public static String getEntityTypeName(@NotNull EntityType entityType) {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_13_2.getVersionId()) {
            return entityType.getKey().getKey();
        }
        return entityType.getName();
    }

    public static double getMaxHealth(@NotNull Player player) {
        return player.getMaxHealth();
    }

    public static void setMaxHealth(@NotNull Player player, double maxHealth) {
        player.setMaxHealth(maxHealth);
    }

    public static Biome getBiome(@NotNull String name) throws Exception {
        if (pPpppP.isEnum()) {
            Enum enum_ = Enum.valueOf(pPpppP.asSubclass(Enum.class), name);
            return (Biome)enum_;
        }
        Class[] classArray = new Class[1];
        classArray[0] = String.class;
        Method method = pPpppP.getMethod(TitleParticleService.PpPpPP("CgYsPIS"), classArray);
        Object[] objectArray = new Object[1];
        objectArray[0] = name;
        return (Biome)method.invoke(null, objectArray);
    }

    public static Enchantment getDurability() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Enchantment.UNBREAKING;
        }
        return LegacyUtil.getEnchantmentByName(TitleParticleService.PpPpPP("B`TtD|J|Rl"));
    }

    public static Particle getRedStone() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Particle.DUST;
        }
        return Particle.valueOf((String)TitleParticleService.PpPpPP("TpBfRzHp"));
    }

    public static PotionEffectType getPotionEffectTypeByName(@NotNull String name) {
        return PotionEffectType.getByName((String)name);
    }

    public static Enchantment getArrowDamage() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Enchantment.POWER;
        }
        return LegacyUtil.getEnchantmentByName(BackUpUtil.PpPpPP("WnDsAcR}[}Qy"));
    }

    public static Sound getSound(@NotNull String sound) throws Exception {
        if (b.isEnum()) {
            Enum enum_ = Enum.valueOf(b.asSubclass(Enum.class), sound.toUpperCase());
            return (Sound)enum_;
        }
        Class[] classArray = new Class[1];
        classArray[0] = String.class;
        Method method = b.getMethod(BackUpUtil.PpPpPP("JwPcYYZ"), classArray);
        Object[] objectArray = new Object[1];
        objectArray[0] = sound.toUpperCase();
        return (Sound)method.invoke(null, objectArray);
    }

    public static Enchantment getEnchantmentByName(@NotNull String name) {
        return Enchantment.getByName((String)name);
    }

    public static List<String> getEnchantmentList() {
        return Arrays.stream(Enchantment.values()).map(Enchantment::getName).collect(Collectors.toList());
    }

    public static String getEnchantmentName(@NotNull Enchantment enchantment) {
        return enchantment.getName();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initClasses() {
        try {
            b = Class.forName(BackUpUtil.PpPpPP("yNq\u0012tI}W\u007fH8oyIxX"));
            G = BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_9.getVersionId() ? Class.forName(TitleParticleService.PpPpPP("iGa\u001bd@m^oA(TrAt\\d@rP(trAt\\d@rP")) : null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(TitleParticleService.PpPpPP("\u65d5\u6cd3\u624b\u5236\u7c4e"), classNotFoundException);
        }
        {
            pPpppP = Class.forName(BackUpUtil.PpPpPP("yNq\u0012tI}W\u007fH8^zSuW8~\u007fS{Y"));
            return;
        }
    }

    public static PotionEffectType getIncreaseDamage() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return PotionEffectType.getByName((String)BackUpUtil.PpPpPP("eHdYx[bT"));
        }
        return PotionEffectType.getByName((String)TitleParticleService.PpPpPP("\\hVtPgFcjbTkTaP"));
    }

    public static List<String> getEntityTypeAliveList() {
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = BaseConstants.VERSION_ID > VersionCheckEnum.V_1_13_2.getVersionId();
        EntityType[] entityTypeArray = EntityType.values();
        int n3 = entityTypeArray.length;
        int n4 = n2 = 0;
        while (n4 < n3) {
            EntityType entityType = entityTypeArray[n2];
            if (entityType.isAlive() && entityType.isSpawnable()) {
                if (bl) {
                    arrayList.add(entityType.getKey().getKey());
                } else {
                    arrayList.add(entityType.getName());
                }
            }
            n4 = ++n2;
        }
        return arrayList;
    }
}

