/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.lib;

import com.handy.playertitle.lib.AssertUtil;
import com.handy.playertitle.lib.PatternUtil;
import com.handy.playertitle.lib.StrUtil;
import com.handy.playertitle.service.TitleParticleService;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Optional;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public final class NumberUtil {
    public static Integer isNumericToInt(@NotNull String str, Integer def) {
        return NumberUtil.isNumericToBigDecimal(str).map(BigDecimal::intValue).orElse(def);
    }

    private /* synthetic */ NumberUtil() {
        NumberUtil a2;
    }

    public static BigDecimal isNumericToBigDecimal(@NotNull String str, BigDecimal def) {
        if (StrUtil.isEmpty(str)) {
            return def;
        }
        str = str.trim();
        try {
            Matcher matcher = PatternUtil.BIG_DECIMAL_NUMERIC.matcher(str);
            if (matcher.matches()) {
                return new BigDecimal(str);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
        return def;
    }

    public static boolean lt(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        if (num1.compareTo(num2) < 0) {
            return true;
        }
        return false;
    }

    public static Long isNumericToLong(@NotNull String str) {
        return NumberUtil.isNumericToLong(str, null);
    }

    public static boolean le(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        if (num1.compareTo(num2) <= 0) {
            return true;
        }
        return false;
    }

    public static BigDecimal toBigDecimal(Number a2) {
        if (null == a2) {
            return BigDecimal.ZERO;
        }
        Number number = a2;
        AssertUtil.isTrue(NumberUtil.isValidNumber(number), TitleParticleService.PpPpPP("H@kWcG&\\u\u0015o[pTj\\b\u0014"));
        if (number instanceof BigDecimal) {
            return (BigDecimal)a2;
        }
        if (a2 instanceof Long) {
            return new BigDecimal((Long)a2);
        }
        if (a2 instanceof Integer) {
            return new BigDecimal((Integer)a2);
        }
        if (a2 instanceof BigInteger) {
            return new BigDecimal((BigInteger)a2);
        }
        return new BigDecimal(a2.toString());
    }

    public static boolean gt(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        if (num1.compareTo(num2) > 0) {
            return true;
        }
        return false;
    }

    public static boolean ge(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        if (num1.compareTo(num2) >= 0) {
            return true;
        }
        return false;
    }

    public static Optional<BigDecimal> isNumericToBigDecimal(@NotNull String str) {
        return Optional.ofNullable(NumberUtil.isNumericToBigDecimal(str, null));
    }

    public static boolean isValidNumber(Number a2) {
        if (null == a2) {
            return false;
        }
        if (a2 instanceof Double) {
            if (!((Double)a2).isInfinite() && !((Double)a2).isNaN()) {
                return true;
            }
            return false;
        }
        if (a2 instanceof Float) {
            if (!((Float)a2).isInfinite() && !((Float)a2).isNaN()) {
                return true;
            }
            return false;
        }
        return true;
    }

    public static BigDecimal div(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        return num1.divide(num2, 2, RoundingMode.HALF_UP);
    }

    public static Long isNumericToLong(@NotNull String str, Long def) {
        return NumberUtil.isNumericToBigDecimal(str).map(BigDecimal::longValue).orElse(def);
    }

    public static Integer isNumericToInt(@NotNull String str) {
        return NumberUtil.isNumericToInt(str, null);
    }

    public static BigDecimal mul(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        num2 = num1.multiply(num2);
        if (num2.scale() > 2) {
            return num2.setScale(2, RoundingMode.HALF_UP);
        }
        return num2;
    }

    public static Double isNumericToDouble(@NotNull String str, Double def) {
        return NumberUtil.isNumericToBigDecimal(str).map(BigDecimal::doubleValue).orElse(def);
    }

    public static Double isNumericToDouble(@NotNull String str) {
        return NumberUtil.isNumericToDouble(str, null);
    }
}

