/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.lib.attribute;

import com.handy.playertitle.lib.BaseUtil;
import com.handy.playertitle.lib.HookPluginEnum;
import com.handy.playertitle.lib.attribute.AttributeEnum;
import com.handy.playertitle.lib.attribute.AttributePlusUtil;
import com.handy.playertitle.lib.attribute.AttributePlusV2Util;
import com.handy.playertitle.lib.attribute.AttributeSystemUtil;
import com.handy.playertitle.lib.attribute.MythicLibUtil;
import com.handy.playertitle.lib.attribute.PotionEffectUtil;
import com.handy.playertitle.lib.attribute.SagaLoreStatsUtil;
import com.handy.playertitle.lib.attribute.SxAttributeUtil;
import com.handy.playertitle.lib.attribute.SxAttributeV2Util;
import java.util.List;
import java.util.Optional;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AttributeUtil {
    private static boolean USE_AP_3;
    private static boolean USE_AP_2;
    private static boolean USE_AS;
    private static boolean USE_SX_3;
    private static boolean USE_SX_2;
    private static boolean USE_MYTHIC;
    private static boolean USE_SAGA;
    private static final AttributeUtil INSTANCE;

    private AttributeUtil() {
    }

    public static AttributeUtil getInstance() {
        AttributeUtil.init();
        return INSTANCE;
    }

    public void addAttribute(Player player, List<String> attributeList, AttributeEnum attributeEnum) {
        if (attributeList == null || attributeList.isEmpty()) {
            return;
        }
        if (player == null || !player.isOnline()) {
            return;
        }
        attributeList = BaseUtil.replaceChatColor(attributeList);
        switch (attributeEnum) {
            case ATTRIBUTE_PLUS: {
                if (USE_AP_3) {
                    AttributePlusUtil.addAttribute((LivingEntity)player, attributeList);
                }
                if (!USE_AP_2) break;
                AttributePlusV2Util.addAttribute(player, attributeList);
                break;
            }
            case ATTRIBUTE_SYSTEM: {
                if (!USE_AS) break;
                AttributeSystemUtil.addAttribute((LivingEntity)player, attributeList);
                break;
            }
            case SX_ATTRIBUTE: {
                if (USE_SX_3) {
                    SxAttributeUtil.addAttribute((LivingEntity)player, attributeList);
                }
                if (!USE_SX_2) break;
                SxAttributeV2Util.addAttribute((LivingEntity)player, attributeList);
                break;
            }
            case POTION_EFFECT: {
                PotionEffectUtil.addAttribute(player, attributeList);
                break;
            }
            case MYTHIC_LIB: {
                if (!USE_MYTHIC) break;
                MythicLibUtil.addAttribute((LivingEntity)player, attributeList);
                break;
            }
            case SAGA_LORE_STATS: {
                if (!USE_SAGA) break;
                SagaLoreStatsUtil.addAttribute((LivingEntity)player, attributeList);
                break;
            }
            default: {
                throw new RuntimeException("\u53c2\u6570\u5f02\u5e38: attributeEnum \u9519\u8bef");
            }
        }
    }

    public void removeAttribute(Player player, AttributeEnum attributeEnum) {
        switch (attributeEnum) {
            case ALL: {
                if (USE_AP_3) {
                    AttributePlusUtil.removeAttribute((LivingEntity)player);
                }
                if (USE_AP_2) {
                    AttributePlusV2Util.removeAttribute(player);
                }
                if (USE_AS) {
                    AttributeSystemUtil.removeAttribute((LivingEntity)player);
                }
                if (USE_SX_3) {
                    SxAttributeUtil.removeAttribute((LivingEntity)player);
                }
                if (USE_SX_2) {
                    SxAttributeV2Util.removeAttribute((LivingEntity)player);
                }
                if (USE_MYTHIC) {
                    MythicLibUtil.removeAttribute((LivingEntity)player);
                }
                if (USE_SAGA) {
                    SagaLoreStatsUtil.removeAttribute((LivingEntity)player);
                }
                PotionEffectUtil.removeAttribute(player);
                break;
            }
            case ATTRIBUTE_PLUS: {
                if (USE_AP_3) {
                    AttributePlusUtil.removeAttribute((LivingEntity)player);
                }
                if (!USE_AP_2) break;
                AttributePlusV2Util.removeAttribute(player);
                break;
            }
            case ATTRIBUTE_SYSTEM: {
                if (!USE_AS) break;
                AttributeSystemUtil.removeAttribute((LivingEntity)player);
                break;
            }
            case SX_ATTRIBUTE: {
                if (USE_SX_3) {
                    SxAttributeUtil.removeAttribute((LivingEntity)player);
                }
                if (!USE_SX_2) break;
                SxAttributeV2Util.removeAttribute((LivingEntity)player);
                break;
            }
            case POTION_EFFECT: {
                PotionEffectUtil.removeAttribute(player);
                break;
            }
            case MYTHIC_LIB: {
                if (!USE_MYTHIC) break;
                MythicLibUtil.removeAttribute((LivingEntity)player);
                break;
            }
            case SAGA_LORE_STATS: {
                if (!USE_SAGA) break;
                SagaLoreStatsUtil.removeAttribute((LivingEntity)player);
                break;
            }
            default: {
                throw new RuntimeException("\u53c2\u6570\u5f02\u5e38: attributeEnum \u9519\u8bef");
            }
        }
    }

    public void addAttribute(LivingEntity entity, List<String> attributeList, AttributeEnum attributeEnum) {
        if (attributeList == null || attributeList.isEmpty()) {
            return;
        }
        if (entity == null) {
            return;
        }
        attributeList = BaseUtil.replaceChatColor(attributeList);
        switch (attributeEnum) {
            case ATTRIBUTE_PLUS: {
                if (!USE_AP_3) break;
                AttributePlusUtil.addAttribute(entity, attributeList);
                break;
            }
            case ATTRIBUTE_SYSTEM: {
                if (!USE_AS) break;
                AttributeSystemUtil.addAttribute(entity, attributeList);
                break;
            }
            case SX_ATTRIBUTE: {
                if (USE_SX_3) {
                    SxAttributeUtil.addAttribute(entity, attributeList);
                }
                if (!USE_SX_2) break;
                SxAttributeV2Util.addAttribute(entity, attributeList);
                break;
            }
            case MYTHIC_LIB: {
                if (!USE_MYTHIC) break;
                MythicLibUtil.addAttribute(entity, attributeList);
                break;
            }
            case SAGA_LORE_STATS: {
                if (!USE_SAGA) break;
                SagaLoreStatsUtil.addAttribute(entity, attributeList);
                break;
            }
            default: {
                throw new RuntimeException("\u53c2\u6570\u5f02\u5e38: attributeEnum \u9519\u8bef");
            }
        }
    }

    public void removeAttribute(LivingEntity entity, AttributeEnum attributeEnum) {
        switch (attributeEnum) {
            case ALL: {
                if (USE_AP_3) {
                    AttributePlusUtil.removeAttribute(entity);
                }
                if (USE_AS) {
                    AttributeSystemUtil.removeAttribute(entity);
                }
                if (USE_SX_3) {
                    SxAttributeUtil.removeAttribute(entity);
                }
                if (USE_SX_2) {
                    SxAttributeV2Util.removeAttribute(entity);
                }
                if (USE_MYTHIC) {
                    MythicLibUtil.removeAttribute(entity);
                }
                if (!USE_SAGA) break;
                SagaLoreStatsUtil.removeAttribute(entity);
                break;
            }
            case ATTRIBUTE_PLUS: {
                if (!USE_AP_3) break;
                AttributePlusUtil.removeAttribute(entity);
                break;
            }
            case ATTRIBUTE_SYSTEM: {
                if (!USE_AS) break;
                AttributeSystemUtil.removeAttribute(entity);
                break;
            }
            case SX_ATTRIBUTE: {
                if (USE_SX_3) {
                    SxAttributeUtil.removeAttribute(entity);
                }
                if (!USE_SX_2) break;
                SxAttributeV2Util.removeAttribute(entity);
                break;
            }
            case MYTHIC_LIB: {
                if (!USE_MYTHIC) break;
                MythicLibUtil.removeAttribute(entity);
                break;
            }
            case SAGA_LORE_STATS: {
                if (!USE_SAGA) break;
                SagaLoreStatsUtil.removeAttribute(entity);
                break;
            }
            default: {
                throw new RuntimeException("\u53c2\u6570\u5f02\u5e38: attributeEnum \u9519\u8bef");
            }
        }
    }

    private static void init() {
        USE_AS = BaseUtil.hook(HookPluginEnum.ATTRIBUTE_SYSTEM.getName()).isPresent();
        Optional<Plugin> sxPluginOpt = BaseUtil.hook(HookPluginEnum.SX_ATTRIBUTE.getName());
        if (sxPluginOpt.isPresent()) {
            if (BaseUtil.getFirstPluginVersion(sxPluginOpt.get()) < 3) {
                USE_SX_2 = true;
            } else {
                USE_SX_3 = true;
            }
        } else {
            USE_SX_2 = false;
            USE_SX_3 = false;
        }
        Optional<Plugin> apPluginOpt = BaseUtil.hook(HookPluginEnum.ATTRIBUTE_PLUS.getName());
        if (apPluginOpt.isPresent()) {
            if (BaseUtil.getFirstPluginVersion(apPluginOpt.get()) < 3) {
                USE_AP_2 = true;
            } else {
                USE_AP_3 = true;
            }
        } else {
            USE_AP_2 = false;
            USE_AP_3 = false;
        }
        USE_MYTHIC = BaseUtil.hook(HookPluginEnum.MYTHIC_LIB.getName()).isPresent();
        if (USE_MYTHIC) {
            USE_MYTHIC = MythicLibUtil.isNewVersion();
        }
        USE_SAGA = BaseUtil.hook(HookPluginEnum.SAGA_LORE_STATS.getName()).isPresent();
    }

    static {
        INSTANCE = new AttributeUtil();
    }
}

