/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.lib.attribute;

import com.handy.playertitle.lib.BaseConstants;
import com.handy.playertitle.lib.CollUtil;
import com.handy.playertitle.lib.JsonUtil;
import com.handy.playertitle.lib.VersionCheckEnum;
import com.handy.playertitle.lib.attribute.PotionEffectParam;
import com.handy.playertitle.lib.expand.adapter.PlayerSchedulerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectUtil {
    protected static final Map<UUID, List<PotionEffectType>> PLAYER_EFFECT_MAP = new ConcurrentHashMap<UUID, List<PotionEffectType>>();

    private PotionEffectUtil() {
    }

    protected static void addAttribute(Player player, List<String> attributeList) {
        ArrayList<PotionEffectParam> peList = new ArrayList<PotionEffectParam>();
        for (String attribute : attributeList) {
            PotionEffectParam potionEffectParam = JsonUtil.toBean(attribute, PotionEffectParam.class);
            peList.add(potionEffectParam);
        }
        ArrayList<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
        ArrayList<PotionEffectType> potionEffectTypeList = new ArrayList<PotionEffectType>();
        for (PotionEffectParam potionEffectParam : peList) {
            PotionEffectType potionEffectType = PotionEffectType.getByName((String)potionEffectParam.getPotionName());
            if (potionEffectType == null) continue;
            PotionEffect potionEffect = PotionEffectUtil.getPotionEffect(potionEffectParam, potionEffectType);
            potionEffects.add(potionEffect);
            potionEffectTypeList.add(potionEffectType);
        }
        if (!potionEffects.isEmpty()) {
            PlayerSchedulerUtil.addPotionEffects((LivingEntity)player, potionEffects);
            List typeList = PLAYER_EFFECT_MAP.getOrDefault(player.getUniqueId(), new ArrayList());
            typeList.addAll(potionEffectTypeList);
            typeList = typeList.stream().distinct().collect(Collectors.toList());
            PLAYER_EFFECT_MAP.put(player.getUniqueId(), typeList);
        }
    }

    private static PotionEffect getPotionEffect(PotionEffectParam potionEffectParam, PotionEffectType potionEffectType) {
        int duration;
        int potionLevel = potionEffectParam.getPotionLevel() - 1;
        if (potionLevel < 0) {
            potionLevel = 0;
        }
        int n2 = duration = potionEffectParam.getDuration() != null ? potionEffectParam.getDuration() : 1728000;
        PotionEffect potionEffect = BaseConstants.VERSION_ID < VersionCheckEnum.V_1_8.getVersionId() ? new PotionEffect(potionEffectType, duration, potionLevel, false) : new PotionEffect(potionEffectType, duration, potionLevel, false, potionEffectParam.getPotionHide() == false);
        return potionEffect;
    }

    protected static void removeAttribute(Player player) {
        List<PotionEffectType> potionEffectTypeList;
        Collection activePotionEffects = player.getActivePotionEffects();
        if (!activePotionEffects.isEmpty() && CollUtil.isNotEmpty(potionEffectTypeList = PLAYER_EFFECT_MAP.get(player.getUniqueId()))) {
            for (PotionEffect potionEffect : activePotionEffects) {
                if (!potionEffectTypeList.contains(potionEffect.getType())) continue;
                PlayerSchedulerUtil.removePotionEffect((LivingEntity)player, potionEffect.getType());
            }
        }
        PLAYER_EFFECT_MAP.remove(player.getUniqueId());
    }
}

