/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.lib.expand.adapter;

import com.handy.playertitle.lib.expand.adapter.BukkitScheduler;
import com.handy.playertitle.lib.expand.adapter.HandySchedulerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class PlayerSchedulerUtil {
    private PlayerSchedulerUtil() {
    }

    public static boolean teleport(@NotNull Entity entity, @NotNull Location target) {
        return PlayerSchedulerUtil.teleport(entity, target, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public static boolean teleport(@NotNull Entity entity, @NotNull Location target, @NotNull PlayerTeleportEvent.TeleportCause cause) {
        if (HandySchedulerUtil.isFolia()) {
            entity.teleportAsync(target, cause);
            return true;
        }
        return entity.teleport(target, cause);
    }

    public static void syncTeleport(@NotNull Entity entity, @NotNull Location target) {
        PlayerSchedulerUtil.syncTeleport(entity, target, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public static void syncTeleport(@NotNull Entity entity, @NotNull Location target, @NotNull PlayerTeleportEvent.TeleportCause cause) {
        if (HandySchedulerUtil.isFolia()) {
            entity.teleportAsync(target, cause);
            return;
        }
        BukkitScheduler.runTask(() -> entity.teleport(target, cause));
    }

    public static void addPotionEffects(@NotNull LivingEntity entity, @NotNull List<PotionEffect> potionEffectList) {
        if (potionEffectList.isEmpty()) {
            return;
        }
        if (HandySchedulerUtil.isFolia()) {
            entity.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a2 -> entity.addPotionEffects((Collection)potionEffectList), () -> {});
            return;
        }
        BukkitScheduler.runTask(() -> entity.addPotionEffects((Collection)potionEffectList));
    }

    public static void addPotionEffects(@NotNull LivingEntity entity, @NotNull PotionEffect potionEffect) {
        PlayerSchedulerUtil.addPotionEffects(entity, Collections.singletonList(potionEffect));
    }

    public static void removePotionEffect(@NotNull LivingEntity entity, @NotNull PotionEffectType potionEffect) {
        if (HandySchedulerUtil.isFolia()) {
            entity.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a2 -> entity.removePotionEffect(potionEffect), () -> {});
            return;
        }
        BukkitScheduler.runTask(() -> entity.removePotionEffect(potionEffect));
    }

    public static void playSound(@NotNull Player player, @NotNull Sound sound, float volume, float pitch) {
        if (HandySchedulerUtil.isFolia()) {
            player.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a2 -> player.playSound(player.getLocation(), sound, volume, pitch), () -> {});
            return;
        }
        BukkitScheduler.runTask(() -> player.playSound(player.getLocation(), sound, volume, pitch));
    }

    public static void playSound(@NotNull Player player, @NotNull String sound, float volume, float pitch) {
        if (HandySchedulerUtil.isFolia()) {
            player.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a2 -> player.playSound(player.getLocation(), sound, volume, pitch), () -> {});
            return;
        }
        BukkitScheduler.runTask(() -> player.playSound(player.getLocation(), sound, volume, pitch));
    }

    public static void performCommand(@NotNull Player player, @NotNull String command) {
        PlayerSchedulerUtil.performCommand(player, command, true, false);
    }

    public static void syncPerformCommand(@NotNull Player player, @NotNull String command) {
        PlayerSchedulerUtil.performCommand(player, command, true, true);
    }

    public static void playerPerformCommand(@NotNull Player player, @NotNull String command) {
        PlayerSchedulerUtil.performCommand(player, command, false, false);
    }

    public static void syncPlayerPerformCommand(@NotNull Player player, @NotNull String command) {
        PlayerSchedulerUtil.performCommand(player, command, false, true);
    }

    public static void openInventory(@NotNull Player player, @NotNull Inventory inventory) {
        PlayerSchedulerUtil.openInventory(player, inventory, false);
    }

    public static void syncOpenInventory(@NotNull Player player, @NotNull Inventory inventory) {
        PlayerSchedulerUtil.openInventory(player, inventory, true);
    }

    public static void closeInventory(@NotNull Player player) {
        PlayerSchedulerUtil.closeInventory(player, false);
    }

    public static void syncCloseInventory(@NotNull Player player) {
        PlayerSchedulerUtil.closeInventory(player, true);
    }

    public static void performOpCommand(@NotNull Player player, @NotNull String command) {
        PlayerSchedulerUtil.opPerformCommand(player, command, true, false);
    }

    public static void syncPerformOpCommand(@NotNull Player player, @NotNull String command) {
        PlayerSchedulerUtil.opPerformCommand(player, command, true, true);
    }

    public static void playerPerformOpCommand(@NotNull Player player, @NotNull String command) {
        PlayerSchedulerUtil.opPerformCommand(player, command, false, false);
    }

    public static void syncPlayerPerformOpCommand(@NotNull Player player, @NotNull String command) {
        PlayerSchedulerUtil.opPerformCommand(player, command, false, true);
    }

    public static void dispatchCommand(@NotNull String command) {
        PlayerSchedulerUtil.dispatchCommand(command, false);
    }

    public static void syncDispatchCommand(@NotNull String command) {
        PlayerSchedulerUtil.dispatchCommand(command, true);
    }

    public static void syncPerformReplaceCommand(@NotNull Player player, @NotNull String command) {
        if (command.contains("[close]")) {
            PlayerSchedulerUtil.syncCloseInventory(player);
            return;
        }
        if ((command = command.replace("${player}", player.getName())).contains("[op]")) {
            String newCommand = command.replace("[op]", "");
            PlayerSchedulerUtil.syncPerformOpCommand(player, newCommand);
            return;
        }
        if (command.contains("[console]")) {
            PlayerSchedulerUtil.syncDispatchCommand(command.replace("[console]", ""));
            return;
        }
        PlayerSchedulerUtil.syncPerformCommand(player, command);
    }

    public static void dropItem(@NotNull Player player, @NotNull List<ItemStack> dropItemList) {
        if (HandySchedulerUtil.isFolia()) {
            player.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, task -> dropItemList.forEach(dropItem -> player.getWorld().dropItem(player.getLocation(), dropItem)), () -> {});
            return;
        }
        HandySchedulerUtil.runTask(() -> dropItemList.forEach(item -> player.getWorld().dropItem(player.getLocation(), item)));
    }

    private static void performCommand(@NotNull Player player, @NotNull String command, boolean isChat, boolean isSync) {
        if (HandySchedulerUtil.isFolia()) {
            player.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a2 -> PlayerSchedulerUtil.performCommand(player, command, isChat), () -> {});
            return;
        }
        if (isSync) {
            BukkitScheduler.runTask(() -> PlayerSchedulerUtil.performCommand(player, command, isChat));
            return;
        }
        PlayerSchedulerUtil.performCommand(player, command, isChat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void opPerformCommand(@NotNull Player player, @NotNull String command, boolean isChat, boolean isSync) {
        boolean op = player.isOp();
        try {
            if (!op) {
                player.setOp(true);
            }
            PlayerSchedulerUtil.performCommand(player, command, isChat, isSync);
        }
        finally {
            player.setOp(op);
        }
    }

    private static void performCommand(@NotNull Player player, @NotNull String command, boolean isChat) {
        if (isChat) {
            player.chat("/" + command.trim());
            return;
        }
        player.performCommand(command.trim());
    }

    private static void dispatchCommand(@NotNull String command, boolean isSync) {
        if (HandySchedulerUtil.isFolia()) {
            HandySchedulerUtil.runTask(() -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.trim()));
            return;
        }
        if (isSync) {
            HandySchedulerUtil.runTask(() -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.trim()));
            return;
        }
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.trim());
    }

    private static void openInventory(@NotNull Player player, @NotNull Inventory inventory, boolean isSync) {
        if (HandySchedulerUtil.isFolia()) {
            player.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a2 -> player.openInventory(inventory), () -> {});
            return;
        }
        if (isSync) {
            BukkitScheduler.runTask(() -> player.openInventory(inventory));
            return;
        }
        player.openInventory(inventory);
    }

    private static void closeInventory(@NotNull Player player, boolean isSync) {
        if (HandySchedulerUtil.isFolia()) {
            player.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a2 -> player.closeInventory(), () -> {});
            return;
        }
        if (isSync) {
            BukkitScheduler.runTask(() -> ((Player)player).closeInventory());
            return;
        }
        player.closeInventory();
    }
}

