/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.api;

import com.handy.playertitle.api.param.TitleBuffParam;
import com.handy.playertitle.api.param.TitleListParam;
import com.handy.playertitle.api.param.TitleParticleParam;
import com.handy.playertitle.constants.BuffType;
import com.handy.playertitle.constants.BuffTypeEnum;
import com.handy.playertitle.constants.BuyTypeEnum;
import com.handy.playertitle.constants.TitleConstants;
import com.handy.playertitle.core.buff.BuffManageUtil;
import com.handy.playertitle.entity.TitleBuff;
import com.handy.playertitle.entity.TitleCoin;
import com.handy.playertitle.entity.TitleList;
import com.handy.playertitle.entity.TitleParticle;
import com.handy.playertitle.entity.TitlePlayer;
import com.handy.playertitle.lib.BaseConstants;
import com.handy.playertitle.lib.BaseUtil;
import com.handy.playertitle.lib.CollUtil;
import com.handy.playertitle.lib.DateUtil;
import com.handy.playertitle.lib.JsonUtil;
import com.handy.playertitle.lib.StrUtil;
import com.handy.playertitle.service.TitleBuffService;
import com.handy.playertitle.service.TitleCoinService;
import com.handy.playertitle.service.TitleListService;
import com.handy.playertitle.service.TitleParticleService;
import com.handy.playertitle.service.TitlePlayerService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PlayerTitleApi {
    private PlayerTitleApi() {
    }

    public static PlayerTitleApi getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public boolean addBuffType(String buffType, String buffTypeName, String pluginName) {
        if (StrUtil.isEmpty(buffType) || !TitleConstants.NAME_PATTERN.matcher(buffType).matches()) {
            throw new RuntimeException("\u6ce8\u518c\u5931\u8d25\uff0cBUFF\u7c7b\u578b\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u53ea\u5141\u8bb8 a-zA-Z_");
        }
        Map<String, BuffType> buffTypeMap = BuffType.getBuffTypeMap();
        if (buffTypeMap.containsKey(buffType)) {
            throw new RuntimeException("\u6ce8\u518c\u5931\u8d25\uff0c\u5df2\u7ecf\u6709\u8be5\u7c7b\u578b\u4e86");
        }
        BuffType.put(buffType, buffTypeName, pluginName);
        return true;
    }

    public boolean findByTitleId(Long titleId) {
        return TitleListService.getInstance().findById(titleId.intValue()).isPresent();
    }

    public Long add(TitleListParam titleListParam) {
        if (StrUtil.isEmpty(titleListParam.getBuyType())) {
            BuyTypeEnum buyTypeEnum = titleListParam.getBuyTypeEnum();
            titleListParam.setBuyType(buyTypeEnum.getBuyType());
        }
        if (titleListParam.getIsPrefixAndSuffix() != null && titleListParam.getIsPrefixAndSuffix().booleanValue()) {
            String prefixBrackets = BaseConstants.CONFIG.getString("prefixBrackets");
            String suffixBrackets = BaseConstants.CONFIG.getString("suffixBrackets");
            titleListParam.setTitleName(prefixBrackets + titleListParam.getTitleName() + suffixBrackets);
        }
        if (CollUtil.isNotEmpty(titleListParam.getTitleBuffs())) {
            for (TitleBuffParam titleBuff : titleListParam.getTitleBuffs()) {
                if (!BuffTypeEnum.POTION_EFFECT.equals((Object)titleBuff.getBuffType()) || titleBuff.getPotionEffectParam() == null) continue;
                titleBuff.setBuffContent(JsonUtil.toJson(titleBuff.getPotionEffectParam()));
            }
        }
        return TitleListService.getInstance().add(titleListParam).longValue();
    }

    public boolean removeTitle(Long titleId) {
        return TitleListService.getInstance().removeById(titleId.intValue());
    }

    public boolean addTitleBuff(Long titleId, List<TitleBuffParam> titleBuffs) {
        boolean rst = false;
        if (CollUtil.isEmpty(titleBuffs)) {
            return false;
        }
        for (TitleBuffParam titleBuffParam : titleBuffs) {
            TitleBuff titleBuff = new TitleBuff();
            titleBuff.setTitleId(titleId.intValue());
            titleBuff.setBuffType(titleBuffParam.getBuffType().getBuffType());
            titleBuff.setBuffContent(titleBuffParam.getBuffContent());
            titleBuff.setDescription(titleBuffParam.getDescription());
            rst = TitleBuffService.getInstance().add(titleBuff);
        }
        return rst;
    }

    public boolean removeTitleBuff(Long titleId) {
        return TitleBuffService.getInstance().removeByTitleId(titleId.intValue());
    }

    public boolean addTitleParticle(Long titleId, TitleParticleParam titleParticleParam) {
        if (titleParticleParam == null) {
            return false;
        }
        TitleParticle titleParticle = new TitleParticle();
        titleParticle.setTitleId(titleId.intValue());
        titleParticle.setParticleType(titleParticleParam.getParticleType().getParticleType());
        titleParticle.setSuperTrailsId(titleParticleParam.getSuperTrailsId());
        titleParticle.setWingColor(titleParticleParam.getWingColor());
        titleParticle.setWingContour(titleParticleParam.getWingContour());
        titleParticle.setWingThirdColor(titleParticleParam.getWingThirdColor());
        return TitleParticleService.getInstance().add(titleParticle);
    }

    public boolean removeTitleParticle(Long titleId) {
        return TitleParticleService.getInstance().removeByTitleId(titleId.intValue());
    }

    public boolean update(Long titleId, String titleName, boolean isPrefixAndSuffix) {
        if (isPrefixAndSuffix) {
            String prefixBrackets = BaseConstants.CONFIG.getString("prefixBrackets");
            String suffixBrackets = BaseConstants.CONFIG.getString("suffixBrackets");
            titleName = prefixBrackets + titleName + suffixBrackets;
        }
        return TitleListService.getInstance().updateName(titleId.intValue(), titleName);
    }

    public boolean updateDescription(Long titleId, String description) {
        return TitleListService.getInstance().updateDescription(titleId.intValue(), description);
    }

    @Deprecated
    public boolean set(String playerName, Long titleId, int day) {
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(playerName);
        return this.set(playerName, offlinePlayer.getUniqueId(), titleId, day);
    }

    public boolean set(String playerName, Long titleId) {
        return this.set(playerName, titleId, 0);
    }

    public boolean set(String playerName, UUID playerUuid, Long titleId, int day) {
        Optional<TitleList> titleListOptional = TitleListService.getInstance().findById(titleId.intValue());
        if (!titleListOptional.isPresent()) {
            return false;
        }
        TitleList titleList = titleListOptional.get();
        String titleName = titleList.getTitleName();
        TitlePlayer titlePlayer = new TitlePlayer();
        titlePlayer.setPlayerName(playerName);
        titlePlayer.setPlayerUuid(playerUuid.toString());
        titlePlayer.setTitleId(titleId.intValue());
        titlePlayer.setTitleName(titleName);
        titlePlayer.setIsUseShow(false);
        titlePlayer.setIsUseBuff(false);
        titlePlayer.setIsUseParticle(false);
        titlePlayer.setExpirationTime(DateUtil.getDate(day != 0 ? day : 36500));
        return TitlePlayerService.getInstance().set(titlePlayer);
    }

    @Deprecated
    public boolean removePlayerTitle(String playerName, Long titleId) {
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(playerName);
        return TitlePlayerService.getInstance().removePlayerTitle(offlinePlayer.getUniqueId(), titleId.intValue());
    }

    public boolean removePlayerTitle(UUID playerUuid, Long titleId) {
        return TitlePlayerService.getInstance().removePlayerTitle(playerUuid, titleId.intValue());
    }

    @Deprecated
    public TitlePlayer findByPlayerNameAndIsUse(Player player) {
        return TitleConstants.TITLE_PLAYER_SHOW_MAP.get(player.getUniqueId());
    }

    public TitlePlayer findByPlayerUuidAndIsUse(Player player) {
        return TitleConstants.TITLE_PLAYER_SHOW_MAP.get(player.getUniqueId());
    }

    @Deprecated
    public TitlePlayer findByPlayerNameAndIsUseBuff(Player player) {
        return TitleConstants.TITLE_PLAYER_BUFF_MAP.get(player.getUniqueId());
    }

    public TitlePlayer findByPlayerUuidAndIsUseBuff(Player player) {
        return TitleConstants.TITLE_PLAYER_BUFF_MAP.get(player.getUniqueId());
    }

    @Deprecated
    public TitlePlayer findByPlayerNameAndIsUseParticle(Player player) {
        return TitleConstants.TITLE_PLAYER_PARTICLE_MAP.get(player.getUniqueId());
    }

    public TitlePlayer findByPlayerUuidAndIsUseParticle(Player player) {
        return TitleConstants.TITLE_PLAYER_PARTICLE_MAP.get(player.getUniqueId());
    }

    @Deprecated
    public Long getPlayerCoinNum(String playerName) {
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(playerName);
        Optional<TitleCoin> titleCoinOptional = TitleCoinService.getInstance().findByPlayerUuid(offlinePlayer.getUniqueId());
        return titleCoinOptional.isPresent() ? (long)titleCoinOptional.get().getAmount().intValue() : 0L;
    }

    @Deprecated
    public boolean addCoin(String playerName, Long amount) {
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(playerName);
        return TitleCoinService.getInstance().give(offlinePlayer.getUniqueId(), amount.intValue());
    }

    @Deprecated
    public boolean subtractCoin(String playerName, Long amount) {
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(playerName);
        return TitleCoinService.getInstance().take(offlinePlayer.getUniqueId(), amount.intValue());
    }

    public Integer getPlayerCoinNum(UUID playerUuid) {
        Optional<TitleCoin> titleCoinOptional = TitleCoinService.getInstance().findByPlayerUuid(playerUuid);
        return titleCoinOptional.isPresent() ? titleCoinOptional.get().getAmount() : 0;
    }

    public boolean addCoin(UUID playerUuid, Integer amount) {
        return TitleCoinService.getInstance().give(playerUuid, amount);
    }

    public boolean subtractCoin(UUID playerUuid, Integer amount) {
        return TitleCoinService.getInstance().take(playerUuid, amount);
    }

    public boolean setCoin(UUID playerUuid, Integer amount) {
        return TitleCoinService.getInstance().set(playerUuid, amount);
    }

    @Deprecated
    public Integer getPlayerTitleNum(String playerName) {
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(playerName);
        return TitlePlayerService.getInstance().findCount(offlinePlayer.getUniqueId());
    }

    public Integer getPlayerTitleNum(UUID playerUuid) {
        return TitlePlayerService.getInstance().findCount(playerUuid);
    }

    public void removeBuff(Player player) {
        if (!BaseConstants.CONFIG.getBoolean("isEnableBuff", true)) {
            return;
        }
        BuffManageUtil.removeBuff(player);
    }

    public void setBuff(Player player) {
        BuffManageUtil.callBuffEvent(player);
    }

    @Deprecated
    public boolean playerExistTitleId(String playerName, Integer titleId) {
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(playerName);
        return TitlePlayerService.getInstance().findByPlayerAndTitleId(offlinePlayer.getUniqueId(), titleId).isPresent();
    }

    public boolean playerExistTitleId(UUID playerUuid, Integer titleId) {
        return TitlePlayerService.getInstance().findByPlayerAndTitleId(playerUuid, titleId).isPresent();
    }

    @Deprecated
    public List<Integer> findAllTitleIdByPlayerName(String playerName) {
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(playerName);
        List<TitlePlayer> titlePlayerList = TitlePlayerService.getInstance().findByPlayer(offlinePlayer.getUniqueId());
        return titlePlayerList.stream().map(TitlePlayer::getTitleId).collect(Collectors.toList());
    }

    public List<Integer> findAllTitleIdByPlayerUuid(UUID playerUuid) {
        List<TitlePlayer> titlePlayerList = TitlePlayerService.getInstance().findByPlayer(playerUuid);
        return titlePlayerList.stream().map(TitlePlayer::getTitleId).collect(Collectors.toList());
    }

    private static class SingletonHolder {
        private static final PlayerTitleApi INSTANCE = new PlayerTitleApi();

        private SingletonHolder() {
        }
    }
}

