/*
 * Decompiled with CFR 0.152.
 */
package net.maxbel.takeitout.mixin.client;

import fi.dy.masa.litematica.materials.MaterialCache;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.InventoryUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.maxbel.takeitout.Takeitout;
import net.maxbel.takeitout.client.ItemStackInventory;
import net.maxbel.takeitout.client.Util;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_640;
import net.minecraft.class_8710;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={WorldUtils.class})
public class LitematicaMixin {
    @Unique
    private static int waitTicks = 0;
    @Unique
    private static boolean waitingForItem = false;
    @Unique
    private static class_2680 waitingState = null;
    @Unique
    private static int retryCount = 0;
    @Unique
    private static int expectedWaitTicks = 40;
    @Unique
    private static long requestTsMs = 0L;

    @Unique
    private static int computeExpectedWaitTicks(class_310 mc) {
        int pingMs = 0;
        try {
            class_640 entry;
            if (mc != null && mc.method_1562() != null && mc.field_1724 != null && (entry = mc.method_1562().method_2871(mc.field_1724.method_5667())) != null) {
                pingMs = entry.method_2959();
            }
        }
        catch (Throwable entry) {
            // empty catch block
        }
        if (pingMs <= 0) {
            pingMs = 180;
        }
        int ms = (int)Math.round((double)pingMs * 2.5 + 200.0);
        int ticks = (ms + 49) / 50;
        ticks = Math.max(20, Math.min(ticks, 200));
        return ticks;
    }

    @Unique
    private static int jitter(int baseTicks, int percent) {
        int spread = Math.max(1, baseTicks * percent / 100);
        return baseTicks + (int)(System.nanoTime() % (2L * (long)spread + 1L)) - spread;
    }

    @Inject(method={"doEasyPlaceAction"}, at={@At(value="INVOKE_ASSIGN", target="Lfi/dy/masa/litematica/materials/MaterialCache;getRequiredBuildItemForState(Lnet/minecraft/block/BlockState;)Lnet/minecraft/item/ItemStack;", shift=At.Shift.AFTER)}, cancellable=true)
    private static void interceptMissingItem(class_310 mc, CallbackInfoReturnable<class_1269> cir) {
        if (mc.field_1724 == null) {
            return;
        }
        class_3965 result = RayTraceUtils.traceToSchematicWorld((class_1297)mc.field_1724, (double)6.0, (boolean)true, (boolean)true);
        if (result == null) {
            return;
        }
        class_2338 pos = result.method_17777();
        WorldSchematic schematic = SchematicWorldHandler.getSchematicWorld();
        class_2680 state = schematic.method_8320(pos);
        class_1799 required = MaterialCache.getInstance().getRequiredBuildItemForState(state);
        class_1799 inHand = mc.field_1724.method_6047();
        if (!InventoryUtils.areStacksEqual((class_1799)inHand, (class_1799)required)) {
            if (!waitingForItem) {
                WorldUtils.doSchematicWorldPickBlock((boolean)true, (class_310)mc);
                waitingForItem = true;
                waitingState = state;
                waitTicks = 0;
                retryCount = 0;
                expectedWaitTicks = LitematicaMixin.computeExpectedWaitTicks(mc);
                requestTsMs = System.currentTimeMillis();
            }
            cir.setReturnValue((Object)class_1269.field_5814);
        }
    }

    @ModifyArg(method={"easyPlaceOnUseTick"}, at=@At(value="INVOKE", target="Lfi/dy/masa/litematica/util/WorldUtils;doEasyPlaceAction(Lnet/minecraft/client/MinecraftClient;)Lnet/minecraft/util/ActionResult;"))
    private static class_310 checkItemAndTick(class_310 client) {
        if (waitingForItem && client.field_1724 != null && waitingState != null) {
            class_1799 required;
            class_1799 inHand = client.field_1724.method_6047();
            if (InventoryUtils.areStacksEqual((class_1799)inHand, (class_1799)(required = MaterialCache.getInstance().getRequiredBuildItemForState(waitingState)))) {
                waitingForItem = false;
                waitingState = null;
                waitTicks = 0;
                retryCount = 0;
            } else {
                if (retryCount == 0 && ++waitTicks >= LitematicaMixin.jitter(expectedWaitTicks / 2, 10)) {
                    WorldUtils.doSchematicWorldPickBlock((boolean)true, (class_310)client);
                    retryCount = 1;
                } else if (retryCount == 1 && waitTicks >= LitematicaMixin.jitter(expectedWaitTicks, 10)) {
                    WorldUtils.doSchematicWorldPickBlock((boolean)true, (class_310)client);
                    retryCount = 2;
                }
                int hardTimeout = expectedWaitTicks + Math.max(10, expectedWaitTicks / 2);
                if (waitTicks >= hardTimeout) {
                    System.out.println("[TakeItOut] Timeout while waiting item from shulker. ping-based " + expectedWaitTicks + "t, waited " + waitTicks + "t, retries " + retryCount);
                    waitingForItem = false;
                    waitingState = null;
                    waitTicks = 0;
                    retryCount = 0;
                }
            }
        }
        return client;
    }

    @Inject(method={"doSchematicWorldPickBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private static void doSchematicWorldPickBlockHook(boolean closest, class_310 mc, CallbackInfoReturnable<Boolean> cir) {
        if (mc == null || mc.field_1724 == null) {
            return;
        }
        int range = (int)WorldUtils.getValidBlockRange((class_310)mc);
        class_3965 hit = RayTraceUtils.traceToSchematicWorld((class_1297)mc.field_1724, (double)range, (boolean)true, (boolean)true);
        if (hit == null || hit.method_17783() != class_239.class_240.field_1332) {
            cir.setReturnValue((Object)false);
            cir.cancel();
            return;
        }
        class_2338 pos = hit.method_17777();
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world == null) {
            cir.setReturnValue((Object)false);
            cir.cancel();
            return;
        }
        class_2680 state = world.method_8320(pos);
        class_1799 required = MaterialCache.getInstance().getRequiredBuildItemForState(state, (class_1937)world, pos);
        if (!InventoryUtils.areStacksAndNbtEqual((class_1799)mc.field_1724.method_6047(), (class_1799)required)) {
            int slot = InventoryUtils.findSlotWithItem((class_1703)mc.field_1724.field_7498, (class_1799)required, (boolean)true);
            if (slot != -1) {
                InventoryUtils.swapItemToMainHand((class_1799)required, (class_310)mc);
            } else {
                ItemStackInventory shInv;
                int inner;
                int shulkerSlot = Util.getShulkerWithStack(mc.field_1724.method_31548(), required);
                if (shulkerSlot != -1 && (inner = Util.getSlotWithStack((class_1263)(shInv = ItemStackInventory.getInventoryFromShulker(mc.field_1724.method_31548().method_5438(shulkerSlot))), required)) != -1) {
                    ClientPlayNetworking.send((class_8710)new Takeitout.GetShulkerStackPayload(inner, shulkerSlot));
                }
            }
        }
        fi.dy.masa.litematica.util.InventoryUtils.schematicWorldPickBlock((class_1799)required, (class_2338)pos, (class_1937)world, (class_310)mc);
        cir.setReturnValue((Object)true);
        cir.cancel();
    }
}

