/*
 * Decompiled with CFR 0.152.
 */
package net.maxbel.takeitout.mixin.client;

import fi.dy.masa.litematica.materials.MaterialCache;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.InventoryUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.maxbel.takeitout.Takeitout;
import net.maxbel.takeitout.client.ItemStackInventory;
import net.maxbel.takeitout.client.Util;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_8710;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={WorldUtils.class})
public class LitematicaMixin {
    @Unique
    private static final int MAX_WAIT_TICKS = 20;
    @Unique
    private static int waitTicks = 0;
    @Unique
    private static boolean waitingForItem = false;
    @Unique
    private static class_2680 waitingState = null;
    @Unique
    private static boolean retried = false;

    @Inject(method={"doEasyPlaceAction"}, at={@At(value="INVOKE_ASSIGN", target="Lfi/dy/masa/litematica/materials/MaterialCache;getRequiredBuildItemForState(Lnet/minecraft/block/BlockState;)Lnet/minecraft/item/ItemStack;", shift=At.Shift.AFTER)}, cancellable=true)
    private static void interceptMissingItem(class_310 mc, CallbackInfoReturnable<class_1269> cir) {
        if (mc.field_1724 == null) {
            return;
        }
        class_3965 result = RayTraceUtils.traceToSchematicWorld((class_1297)mc.field_1724, (double)3.0, (boolean)true, (boolean)true);
        if (result == null) {
            return;
        }
        class_2338 pos = result.method_17777();
        WorldSchematic schematic = SchematicWorldHandler.getSchematicWorld();
        class_2680 state = schematic.method_8320(pos);
        class_1799 required = MaterialCache.getInstance().getRequiredBuildItemForState(state);
        class_1799 inHand = mc.field_1724.method_6047();
        if (!InventoryUtils.areStacksEqual((class_1799)inHand, (class_1799)required)) {
            if (!waitingForItem) {
                WorldUtils.doSchematicWorldPickBlock((boolean)false, (class_310)mc);
                waitingForItem = true;
                waitingState = state;
            }
            cir.setReturnValue((Object)class_1269.field_5814);
        }
    }

    @ModifyArg(method={"easyPlaceOnUseTick"}, at=@At(value="INVOKE", target="Lfi/dy/masa/litematica/util/WorldUtils;doEasyPlaceAction(Lnet/minecraft/client/MinecraftClient;)Lnet/minecraft/util/ActionResult;"))
    private static class_310 checkItemAndTick(class_310 client) {
        if (waitingForItem && client.field_1724 != null && waitingState != null) {
            class_1799 required;
            class_1799 inHand = client.field_1724.method_6047();
            if (InventoryUtils.areStacksEqual((class_1799)inHand, (class_1799)(required = MaterialCache.getInstance().getRequiredBuildItemForState(waitingState)))) {
                waitingForItem = false;
                waitingState = null;
                waitTicks = 0;
                retried = false;
            } else {
                if (!retried && ++waitTicks == 10) {
                    WorldUtils.doSchematicWorldPickBlock((boolean)false, (class_310)client);
                    retried = true;
                }
                if (waitTicks >= 20) {
                    System.out.println("[TakeItOut] Failed to receive item from shulker within timeout.");
                    waitingForItem = false;
                    waitingState = null;
                    waitTicks = 0;
                    retried = false;
                }
            }
        }
        return client;
    }

    @Inject(method={"doSchematicWorldPickBlock"}, at={@At(value="HEAD")}, remap=true, cancellable=true)
    private static void doSchematicWorldPickBlockHook(boolean closest, class_310 mc, CallbackInfoReturnable<Boolean> cir) {
        WorldSchematic world;
        class_2338 pos = RayTraceUtils.getSchematicWorldTraceIfClosest((class_1937)mc.field_1687, (class_1297)mc.field_1724, (double)6.0);
        if (pos != null && (world = SchematicWorldHandler.getSchematicWorld()) != null) {
            int slot;
            class_2680 state = world.method_8320(pos);
            class_1799 stack = MaterialCache.getInstance().getRequiredBuildItemForState(state, (class_1937)world, pos);
            if (mc.field_1724.method_31548().method_7395(stack) != -1) {
                return;
            }
            int shulker = Util.getShulkerWithStack(mc.field_1724.method_31548(), stack);
            if (shulker != -1 && (slot = Util.getSlotWithStack((class_1263)ItemStackInventory.getInventoryFromShulker(mc.field_1724.method_31548().method_5438(shulker)), stack)) != -1) {
                ClientPlayNetworking.send((class_8710)new Takeitout.GetShulkerStackPayload(slot, shulker));
            }
        }
    }
}

